/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.factories;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.util.Map;

public class VoxeetIntentFactory {
    private static final String defaultError = "Default activity to be triggered when receiving a notification has not been set. Please use setPathToActivity() with the path of the desired activity.";
    public static final String CONF_ID = "ConfId";
    public static final String INVITER_NAME = "DisplayName";
    public static final String INVITER_EXTERNAL_ID = "ExternalId";
    public static final String INVITER_ID = "UserId";
    public static final String INVITER_URL = "AvatarUrl";
    public static final String NOTIF_TYPE = "NotifType";
    public static final String[] DEFAULT_NOTIFICATION_KEYS = new String[]{"UserId", "DisplayName", "NotifType", "ExternalId", "AvatarUrl", "ConfId"};
    private static final String TAG = VoxeetIntentFactory.class.getSimpleName();

    private static Class<?> createClass(String path) {
        if (path == null) {
            throw new IllegalStateException(defaultError);
        }
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Intent buildFrom(Context context, String path, Map<String, String> data) {
        Class<?> newClass = VoxeetIntentFactory.createClass(path);
        for (String string2 : data.keySet()) {
            Log.d((String)TAG, (String)("buildFrom: " + string2 + " " + data.get(string2)));
        }
        if (newClass != null) {
            Intent intent = new Intent();
            intent.setClass(context, newClass);
            for (String key : DEFAULT_NOTIFICATION_KEYS) {
                if (!data.containsKey(key)) continue;
                intent.putExtra(key, data.get(key));
            }
            intent.putExtra("join", true);
            intent.putExtra("callMode", 1);
            intent.addFlags(4);
            intent.addFlags(0x10000000);
            return intent;
        }
        return null;
    }
}

