package voxeet.com.sdk.factories;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import java.util.Map;

/**
 * Created by romainbenmansour on 30/03/2017.
 */
public class VoxeetIntentFactory {

    /**
     * Error message when failing to create activity class.
     */
    private final static String defaultError = "Default activity to be triggered when receiving a notification has not been set. Please use setPathToActivity() with the path of the desired activity.";

    public static final String CONF_ID = "ConfId";

    public static final String INVITER_NAME = "DisplayName";

    public static final String INVITER_EXTERNAL_ID = "ExternalId";

    public static final String INVITER_ID = "UserId";

    public static final String INVITER_URL = "AvatarUrl";

    public static final String NOTIF_TYPE = "NotifType";

    public static final String[] DEFAULT_NOTIFICATION_KEYS = new String[]{
            INVITER_ID,
            INVITER_NAME,
            NOTIF_TYPE,
            INVITER_EXTERNAL_ID,
            INVITER_URL,
            CONF_ID
    };

    private static final String TAG = VoxeetIntentFactory.class.getSimpleName();

    /**
     * Creates class from a path
     */
    private static Class<?> createClass(String path) {
        if (path == null)
            throw new IllegalStateException(defaultError);

        try {
            return Class.forName(path);
        } catch (ClassNotFoundException e) {
            return null;
        }
    }

    /**
     * Build intent.
     *
     * @param context the context
     * @param path    the path
     * @param data
     * @return the intent
     */
    public static Intent buildFrom(Context context, String path, Map<String, String> data) {
        Class<?> newClass = createClass(path);

        for (String string : data.keySet()) {
            Log.d(TAG, "buildFrom: "+ string +" "+data.get(string));
        }

        if (newClass != null) {
            Intent intent = new Intent();
            intent.setClass(context, newClass);

            for (String key : DEFAULT_NOTIFICATION_KEYS) {
                if(data.containsKey(key)) {
                    intent.putExtra(key, data.get(key));
                }
            }
            /*if (data.containsKey(CONF_ID))
                intent.putExtra("conferenceId", data.get(CONF_ID));
            if (data.containsKey(INVITER_URL))
                intent.putExtra("avatarUrl", data.get(INVITER_URL));
            if (data.containsKey(INVITER_NAME))
                intent.putExtra("inviterName", data.get(INVITER_NAME));
            if (data.containsKey(INVITER_ID))
                intent.putExtra("inviterId", data.get(INVITER_ID));*/

            //force conference join since it is a push
            intent.putExtra("join", true);
            intent.putExtra("callMode", 0x0001);
            intent.addFlags(Intent.FLAG_FROM_BACKGROUND);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            return intent;
        }
        return null;
    }
}
