package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;

import org.greenrobot.eventbus.EventBus;

import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.events.ConferenceTimeoutUserJoinedEvent;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.utils.Twig;

/**
 *
 */

public class TimeoutRunnable implements Runnable {

    private static final String TAG = TimeoutRunnable.class.getSimpleName();

    private long mTimeout;
    private @NonNull
    EventBus mEventBus; //initialized with parametered-constructor
    private @NonNull
    Twig mLogger; //initialized with parametered-constructor
    private @NonNull
    AbstractConferenceSdkService mService; //initialized with parametered-constructor
    private boolean mCanceled;
    private boolean mTriggered;

    /**
     * Default constructor, make the runnable "not canceled" by default
     * and triggered is false
     */
    private TimeoutRunnable() {
        setCanceled(false);
        mTriggered = false;
    }

    /**
     * @param service   the service which will be called back
     * @param logger    a logger to send the few logs this class will manage
     * @param event_bus the configured event bus
     * @param timeout   the current timeout
     */
    public TimeoutRunnable(@NonNull AbstractConferenceSdkService service,
                           @NonNull Twig logger,
                           @NonNull EventBus event_bus,
                           long timeout) {
        this();

        mService = service;
        mLogger = logger;
        mEventBus = event_bus;
        mTimeout = timeout;
    }

    public void setCanceled(boolean canceled) {
        mCanceled = canceled;
    }

    public boolean isCanceled() {
        return mCanceled;
    }

    @Override
    public void run() {

        DefaultConference conference = mService.getConference();

        if (!isCanceled()) {
            mLogger.i("No conference user joined after " + mTimeout
                    + "ms. Now Attempting to leave the conference");

            mService.leave();

            //conference was left after Xms
            //note that if you change the timeout after calling the join, the
            //value returned is absolutely inaccurate

            mEventBus.post(new ConferenceTimeoutUserJoinedEvent(mTimeout));
            mTriggered = true;
        }
    }

    public boolean isTriggered() {
        return mTriggered;
    }
}
