package voxeet.com.sdk.audio;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;

import java.util.ArrayList;
import java.util.List;

public class MessagingEnvironment {

    public static class Builder {
        private Context _context;
        private MessagingEnvironment _messaging_environment;

        private Builder() {
            _messaging_environment = new MessagingEnvironment();
        }

        public Builder(@NonNull Context context) {
            this();

            _context = context;
        }

        public Builder setServerHost(@StringRes int host) {
            _messaging_environment.addServerHost(_context.getString(host));

            return this;
        }

        public Builder setServerPort(@StringRes int port) {
            int server_port = Integer.parseInt(_context.getString(port));
            _messaging_environment.setServerPort(server_port);

            return this;
        }

        public Builder setStunHost(@StringRes int stun_host) {
            _messaging_environment.setStunHost(_context.getString(stun_host));

            return this;
        }

        public Builder setStunPort(@StringRes int stun_port) {
            int stun_server_port = Integer.parseInt(_context.getString(stun_port));
            _messaging_environment.setStunPort(stun_server_port);

            return this;
        }

        public MessagingEnvironment build() {
            return _messaging_environment;
        }
    }

    static final int defaultConnectionTimeout = 15000;
    static final int defaultKeepAliveInterval = 30000;
    static final int defaultReconnectionDelay = 1500;
    static final int defaultReconnectionLimit = 60000;
    static final int defaultMaxReconnectionAttempts = 5;

    private List<String> serverHosts;
    private int serverPort;

    private String stunHost;
    private int stunPort;

    private int connectionTimeout;
    private int searchPageSize;
    private int keepAliveInterval;

    /**
     * Initial timeout to start a reconnect
     */
    private int reconnectionDelay;

    /**
     * The max reconnection delay in milliseconds
     */
    private int reconnectionLimit;

    /**
     * How many times should connection attempt to reconnect with the server after a a dropped connection
     */
    private int maxReconnectionAttempts;

    private MessagingEnvironment() {
        this.connectionTimeout = defaultConnectionTimeout;
        this.keepAliveInterval = defaultKeepAliveInterval;
        this.reconnectionDelay = defaultReconnectionDelay;
        this.reconnectionLimit = defaultReconnectionLimit;
        this.maxReconnectionAttempts = defaultMaxReconnectionAttempts;

        this.serverHosts = new ArrayList<String>();
    }

    public int getReconnectionDelay() {
        return reconnectionDelay;
    }

    public int getReconnectionLimit() {
        return reconnectionLimit;
    }

    public int getMaxReconnectionAttempts() {
        return maxReconnectionAttempts;
    }

    public List<String> getServerHosts() {
        return serverHosts;
    }

    public void addServerHost(String address) {
        serverHosts.add(address);
    }

    public int getServerPort() {
        return serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setStunHost(String stunHost) {
        this.stunHost = stunHost;
    }

    public String getStunHost() {
        return this.stunHost;
    }

    public void setStunPort(int stunPort) {
        this.stunPort = stunPort;
    }

    public int getStunPort() {
        return this.stunPort;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSearchPageSize() {
        return searchPageSize;
    }

    public void setSearchPageSize(int searchPageSize) {
        this.searchPageSize = searchPageSize;
    }

    public int getKeepAliveInterval() {
        return keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }
}
