package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.impl.DefaultFile;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_ADDED)
public class FileSharedEvent extends Event {

    private List<DefaultFile> files;

    public List<DefaultFile> getFiles() {
        return files;
    }

    public void setFiles(List<DefaultFile> files) {
        this.files = files;
    }

    @Override
    public String getType() {
        return EventNames.FILE_ADDED;
    }
}
