package voxeet.com.sdk.firebase;

import android.content.Intent;
import android.support.annotation.NonNull;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import org.greenrobot.eventbus.EventBus;

import voxeet.com.sdk.core.FirebaseController;
import voxeet.com.sdk.core.VoxeetPreferences;
import voxeet.com.sdk.factories.VoxeetIntentFactory;
import voxeet.com.sdk.json.ConferenceDestroyedPush;

/**
 * Created by romainbenmansour on 01/07/16.
 */
public class VoxeetFirebaseMessagingService extends FirebaseMessagingService {

    private final String TAG = VoxeetFirebaseMessagingService.class.getSimpleName();

    private final EventBus eventBus = EventBus.getDefault();

    public static final String NOTIF_TYPE_INVITATION_RECEIVED = "1";
    public static final String NOTIF_TYPE_CONTACT_SUBSCRIPTION_RECEIVED = "2";
    public static final String NOTIF_TYPE_OWN_EVENTS_CLEARED = "3";
    public static final String NOTIF_TYPE_OWN_ACTIVITIES_CLEARED = "4";
    public static final String NOTIF_TYPE_LOCAL_CONFERENCE_DESTROYED = "5";
    public static final String NOTIF_TYPE_OWN_CONFERENCE_CREATED = "6";
    public static final String NOTIF_TYPE_CONTACTS_SUGGESTION = "7";
    public static final String NOTIF_TYPE_MESSAGE_RECEIVED = "8";

    @Override
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
        FirebaseController.getInstance().log("New notification with body " + remoteMessage.getData());

        if (remoteMessage.getData().containsKey(VoxeetIntentFactory.NOTIF_TYPE)) {
            if (remoteMessage.getData().get(VoxeetIntentFactory.NOTIF_TYPE).equalsIgnoreCase(NOTIF_TYPE_INVITATION_RECEIVED)) {
                Intent intent = VoxeetIntentFactory.buildFrom(getApplicationContext(), VoxeetPreferences.getDefaultActivity(), remoteMessage.getData());
                if (intent != null)
                    getApplicationContext().startActivity(intent);
            } else if (remoteMessage.getData().get(VoxeetIntentFactory.NOTIF_TYPE).equalsIgnoreCase(NOTIF_TYPE_LOCAL_CONFERENCE_DESTROYED)) {
                eventBus.post(new ConferenceDestroyedPush());
            }
        }
    }
}
