/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.voxeet.android.media.Media;
import com.voxeet.android.media.MediaException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.VideoRenderer;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.SdpCandidate;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.settings.AudioSettings;
import com.voxeet.android.media.video.CameraEnumerationAndroid;
import com.voxeet.android.media.video.EglBase;
import com.voxeet.android.media.video.VideoCapturerAndroid;
import com.voxeet.kernel.R;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Response;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.audio.MessagingEnvironment;
import voxeet.com.sdk.core.VoxeetPreferences;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.services.AbstractVoxeetClientService;
import voxeet.com.sdk.core.services.SdkConferenceService;
import voxeet.com.sdk.core.services.TimeoutRunnable;
import voxeet.com.sdk.events.error.CameraSwitchErrorEvent;
import voxeet.com.sdk.events.error.ConferenceCreatedError;
import voxeet.com.sdk.events.error.ConferenceJoinedError;
import voxeet.com.sdk.events.error.ConferenceLeftError;
import voxeet.com.sdk.events.error.GetConferenceHistoryErrorEvent;
import voxeet.com.sdk.events.error.GetConferenceStatusErrorEvent;
import voxeet.com.sdk.events.error.ParticipantAddedErrorEvent;
import voxeet.com.sdk.events.error.ReplayConferenceErrorEvent;
import voxeet.com.sdk.events.error.SdkLogoutErrorEvent;
import voxeet.com.sdk.events.error.SubscribeConferenceErrorEvent;
import voxeet.com.sdk.events.success.AddConferenceParticipantResultEvent;
import voxeet.com.sdk.events.success.CameraSwitchSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.events.success.ConferenceDestroyedPushEvent;
import voxeet.com.sdk.events.success.ConferenceEndedEvent;
import voxeet.com.sdk.events.success.ConferenceJoinedSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceLeftSuccessEvent;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceRefreshedEvent;
import voxeet.com.sdk.events.success.ConferenceUserAddedEvent;
import voxeet.com.sdk.events.success.ConferenceUserCallDeclinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserLeftEvent;
import voxeet.com.sdk.events.success.ConferenceUserQualityUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUsersInvitedEvent;
import voxeet.com.sdk.events.success.DeclineConferenceResultEvent;
import voxeet.com.sdk.events.success.GetConferenceHistoryEvent;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.InvitationReceived;
import voxeet.com.sdk.events.success.OfferCreatedEvent;
import voxeet.com.sdk.events.success.OwnConferenceStartedEvent;
import voxeet.com.sdk.events.success.ParticipantAddedEvent;
import voxeet.com.sdk.events.success.ParticipantUpdatedEvent;
import voxeet.com.sdk.events.success.QualityUpdatedEvent;
import voxeet.com.sdk.events.success.RecordingStatusUpdate;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.events.success.ScreenStreamAddedEvent;
import voxeet.com.sdk.events.success.ScreenStreamRemovedEvent;
import voxeet.com.sdk.events.success.SdkLogoutSuccessEvent;
import voxeet.com.sdk.events.success.SendBroadcastResultEvent;
import voxeet.com.sdk.events.success.StartRecordingResultEvent;
import voxeet.com.sdk.events.success.StartVideoAnswerEvent;
import voxeet.com.sdk.events.success.StopRecordingResultEvent;
import voxeet.com.sdk.events.success.StopVideoAnswerEvent;
import voxeet.com.sdk.events.success.SubscribeConferenceEvent;
import voxeet.com.sdk.events.success.UnSubscribeConferenceAnswerEvent;
import voxeet.com.sdk.factories.VoxeetIntentFactory;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.ConferenceUserAdded;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.OfferCreated;
import voxeet.com.sdk.json.RecordingStatusUpdateEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.ConferenceQuality;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.ConferenceType;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.OfferCandidate;
import voxeet.com.sdk.models.OfferDescription;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.SubscribeConference;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.Validate;

public abstract class AbstractConferenceSdkService<T, COP extends AbstractConferenceSdkObservableProvider<T, DemoEvent>, DemoEvent>
extends AbstractVoxeetClientService<T>
implements SdkConferenceService,
ConferenceListener {
    private final String TAG = AbstractConferenceSdkService.class.getSimpleName();
    private VoxeetSdkTemplate sdk;
    private ConferenceListener listener;
    private AbstractConferenceSdkObservableProvider conference_observable_provider;
    protected Context context;
    private Twig twig;
    private DefaultConference conference;
    private String conferenceId = null;
    private String conferenceAlias = null;
    private EventBus eventBus;
    private Media media;
    private EglBase eglBase = EglBase.create();
    private final MessagingEnvironment environment;
    private boolean listenerMode = false;
    private boolean isVideoOn = false;
    private boolean isMicrophoneOn = true;
    private boolean isRecording = false;
    private boolean inConference = false;
    private long timeOutTimer = -1L;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private Media.MediaStreamListener mediaStreamListener = new Media.MediaStreamListener(){

        public void onStreamAdded(final String peer, final MediaStream stream) {
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.updateConferenceParticipants(peer, ConferenceUserStatus.ON_AIR);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("New conference user joined with id: " + user.getUserId(), new Object[0]);
                        if (!peer.equalsIgnoreCase(VoxeetPreferences.id()) && AbstractConferenceSdkService.this.timeOutTimer != -1L) {
                            AbstractConferenceSdkService.this.twig.i("Cancelling timeout timer", new Object[0]);
                            AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        }
                        AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
                    }
                }
            });
        }

        public void onStreamUpdated(final String peer, final MediaStream stream) {
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.findUserById(peer);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + user.getUserId(), new Object[0]);
                        AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                    }
                }
            });
        }

        public void onStreamRemoved(final String peer) {
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.findUserById(peer);
                    if (user != null) {
                        AbstractConferenceSdkService.this.startTransactionConferenceUser();
                        user.setConferenceStatus(ConferenceUserStatus.LEFT);
                        if (AbstractConferenceSdkService.this.conference.getConferenceUsers().contains(user)) {
                            AbstractConferenceSdkService.this.conference.getConferenceUsers().remove(user);
                        }
                        AbstractConferenceSdkService.this.getTwig().i("Conference user left with id: " + user.getUserId(), new Object[0]);
                        AbstractConferenceSdkService.this.commitTransactionConferenceUser();
                        AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceUserLeftEvent(user));
                    }
                }
            });
        }

        public void onScreenStreamAdded(String peer, MediaStream stream) {
            AbstractConferenceSdkService.this.getTwig().i("Screen share stream added: " + peer, new Object[0]);
            AbstractConferenceSdkService.this.eventBus.post((Object)new ScreenStreamAddedEvent(peer, stream));
        }

        public void onScreenStreamRemoved(String peer) {
            AbstractConferenceSdkService.this.getTwig().i("Screen share stream removed: " + peer, new Object[0]);
            AbstractConferenceSdkService.this.eventBus.post((Object)new ScreenStreamRemovedEvent(peer));
        }
    };
    private boolean hasRequestedInvitation = false;
    private String mDefaultCamera = CameraEnumerationAndroid.getNameOfFrontFacingDevice();

    public AbstractConferenceSdkService(VoxeetSdkTemplate instance, COP conference_observable_provider, long timeout, T service) {
        super(instance, service);
        this.conference_observable_provider = conference_observable_provider;
        ((AbstractConferenceSdkObservableProvider)conference_observable_provider).setRetrofitInstantiatedProvider(this.getService());
        this.listener = instance;
        this.sdk = instance;
        this.timeOutTimer = timeout;
        this.twig = instance.getTwig();
        this.eventBus = EventBus.getDefault();
        this.context = instance.getApplicationContext();
        this.environment = new MessagingEnvironment.Builder(this.context).setServerHost(R.string.session_manager_url).setServerPort(R.string.connectionManagerPort).setStunHost(R.string.stunHost).setStunPort(R.string.stunPort).build();
        this.register();
    }

    @Override
    public void setListenerMode(boolean isListener) {
        this.isMicrophoneOn = !isListener;
    }

    @Override
    public void listenConference(String conferenceId) {
        this.listenerMode = true;
        this.getTwig().i("Listener mode set to true", new Object[0]);
        this.join(conferenceId);
    }

    protected void setMediaStreamListener() {
        Validate.notNull(this.media, "media");
        if (this.media != null) {
            this.media.setMediaStreamListener(this.mediaStreamListener);
        }
    }

    @Override
    public boolean attachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.media != null) {
            this.media.attachMediaStream(render, stream);
            return true;
        }
        return false;
    }

    @Override
    public boolean unAttachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.media != null) {
            this.media.unattachMediaStream(render, stream);
            return true;
        }
        return false;
    }

    @Override
    public void decline(final String conferenceId) {
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.getDeclineObservable(conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e(e);
                AbstractConferenceSdkService.this.eventBus.post((Object)new DeclineConferenceResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
            }

            public void onNext(Response<ResponseBody> response) {
                AbstractConferenceSdkService.this.getTwig().i("IConference declined with id: " + conferenceId, new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new DeclineConferenceResultEvent(response.code() == 200));
            }
        });
    }

    @Override
    public void register() {
        this.registerEventBus();
    }

    @Override
    public void unregister() {
        this.unRegisterEventBus();
    }

    protected DefaultConferenceUser updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        DefaultConferenceUser user = this.findUserById(userId);
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setIsOwner(this.conference.getOwnerProfile() == null || this.conference.getOwnerProfile().getUserId().equals(user.getProfile().getUserId()));
            user.setConferenceStatus(status);
            user.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
            this.commitTransactionConferenceUser();
            return user;
        }
        return null;
    }

    protected void initMedia() {
        Validate.notNull(this.context, "context");
        Validate.notNull(this.environment, "environment");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        if (this.media == null) {
            try {
                this.media = new Media(VoxeetPreferences.id(), this.context, this.isVideoOn, this.isMicrophoneOn, new AudioSettings(this.environment.getStunHost(), this.environment.getStunPort()));
                this.setMediaStreamListener();
                this.getTwig().i("Media started with video set to: " + this.isVideoOn + " and microphone to: " + this.isMicrophoneOn, new Object[0]);
            }
            catch (MediaException e) {
                this.getTwig().e(e);
            }
        }
    }

    public void setDefaultCamera(String cameraName) {
        this.mDefaultCamera = cameraName;
    }

    public void startVideo() {
        Validate.notNull(this.media, "media");
        this.media.startVideo(this.mDefaultCamera);
        Observable<StartVideoResponse> stopVideo = this.conference_observable_provider.getStartVideoObservable(this.conferenceId, VoxeetPreferences.id());
        stopVideo.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<StartVideoResponse>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.twig.e(e);
                AbstractConferenceSdkService.this.eventBus.post((Object)new StartVideoAnswerEvent(false));
            }

            public void onNext(StartVideoResponse response) {
                AbstractConferenceSdkService.this.media.startVideo(AbstractConferenceSdkService.this.mDefaultCamera);
                AbstractConferenceSdkService.this.isVideoOn = true;
                AbstractConferenceSdkService.this.createVideoAsnwer(response.getUserId(), response.getDescription(), response.getCandidates());
                AbstractConferenceSdkService.this.eventBus.post((Object)new StartVideoAnswerEvent(true));
            }
        });
    }

    public void stopVideo() {
        String conferenceId = this.getCurrentConferenceId();
        Validate.notNull(conferenceId, "conference Id");
        Validate.notNull(this.media, "media");
        this.media.stopVideo();
        Observable<StopVideoResponse> stopVideo = this.conference_observable_provider.getStopVideoObservable(conferenceId, VoxeetPreferences.id());
        stopVideo.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<StopVideoResponse>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e(e);
                AbstractConferenceSdkService.this.eventBus.post((Object)new StopVideoAnswerEvent(false));
            }

            public void onNext(StopVideoResponse response) {
                AbstractConferenceSdkService.this.media.stopVideo();
                AbstractConferenceSdkService.this.isVideoOn = false;
                AbstractConferenceSdkService.this.createVideoAsnwer(response.getUserId(), response.getDescription(), response.getCandidates());
            }
        });
    }

    private void createVideoAsnwer(final String userId, OfferDescription offerDescription, List<OfferCandidate> offerCandidates) {
        Validate.notNull(this.media, "media");
        SdpDescription description = new SdpDescription(offerDescription.getType(), offerDescription.getSdp());
        ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
        if (offerCandidates != null) {
            for (OfferCandidate candidate : offerCandidates) {
                candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
            }
        }
        this.media.createAnswerForPeer(userId, description.getSsrc(), description, candidates, VoxeetPreferences.id().equalsIgnoreCase(userId), new PendingPeerCallback(){

            public void onMessage(SdpMessage message) {
                AbstractConferenceSdkService.this.answer(userId, message);
            }
        });
    }

    @Override
    public void toggleVideo() {
        if (this.isVideoOn) {
            this.stopVideo();
        } else if (Validate.hasCameraPermissions(this.context)) {
            this.startVideo();
        }
    }

    @Override
    public boolean create() {
        this.getTwig().i("Attempting to create conference", new Object[0]);
        this.conference_observable_provider.getCreateConferenceObservable().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ConferenceResponse>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.twig.e(e);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(ConferenceResponse response) {
                AbstractConferenceSdkService.this.conference = AbstractConferenceSdkService.this.createConference();
                AbstractConferenceSdkService.this.conferenceId = response.getConfId();
                AbstractConferenceSdkService.this.conferenceAlias = response.getConfAlias();
                AbstractConferenceSdkService.this.conference.setConferenceId(AbstractConferenceSdkService.this.conferenceId);
                AbstractConferenceSdkService.this.conference.setConferenceAlias(AbstractConferenceSdkService.this.conferenceAlias);
                AbstractConferenceSdkService.this.getTwig().i("IConference created with id: " + AbstractConferenceSdkService.this.conferenceId, new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceCreationSuccess(response.getConfId(), response.getConfAlias()));
                AbstractConferenceSdkService.this.onCreationSuccess(response.getConfId());
            }
        });
        return true;
    }

    @Override
    public void demo() {
        this.getTwig().i("Attempting to create demo conference", new Object[0]);
        Observable user = this.conference_observable_provider.getCreateDemoObservable();
        user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<DemoEvent>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e(e);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(DemoEvent response) {
                AbstractConferenceSdkService.this.onCreateDemoSuccess(response);
            }
        });
    }

    protected abstract void onCreateDemoSuccess(DemoEvent var1);

    @Override
    public void invite(List<String> voxeetIds, final List<String> externalIds) {
        this.removeTimeoutCallbacks();
        this.sendTimeoutCallbacks();
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.getInviteObservable(this.conferenceId, new SdkConferenceInvitation(voxeetIds, externalIds));
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e(e);
                AbstractConferenceSdkService.this.eventBus.post((Object)new AddConferenceParticipantResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
            }

            public void onNext(Response<ResponseBody> response) {
                AbstractConferenceSdkService.this.eventBus.post((Object)new AddConferenceParticipantResultEvent(response.code() == 200));
                if (response.code() == 200) {
                    for (String userId : externalIds) {
                        if (userId.equals(VoxeetPreferences.id())) continue;
                        AbstractConferenceSdkService.this.getTwig().i("Conference participant with id: " + userId + " invited", new Object[0]);
                        AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceRefreshedEvent(AbstractConferenceSdkService.this.updateConferenceParticipants(userId, ConferenceUserStatus.IN_PROGRESS)));
                    }
                }
            }
        });
    }

    @Override
    public void logout() {
        if (VoxeetPreferences.isLoggedIn()) {
            this.twig.i("Attempting to logout", new Object[0]);
            Observable<Response<ResponseBody>> user = this.conference_observable_provider.getLogOutObservable(VoxeetPreferences.token());
            user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    AbstractConferenceSdkService.this.getTwig().e(e);
                    AbstractConferenceSdkService.this.eventBus.post((Object)new SdkLogoutErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                }

                public void onNext(Response<ResponseBody> response) {
                    if (response.code() == 200) {
                        String message = "Logout success";
                        AbstractConferenceSdkService.this.getTwig().i(message, new Object[0]);
                        VoxeetPreferences.onLogout();
                        AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                        AbstractConferenceSdkService.this.eventBus.post((Object)new SdkLogoutSuccessEvent(message));
                    } else {
                        String message = "Logout failed";
                        AbstractConferenceSdkService.this.getTwig().e(message, new Object[0]);
                        AbstractConferenceSdkService.this.eventBus.post((Object)new SdkLogoutErrorEvent(message));
                    }
                }
            });
        } else {
            String message = "Already logged out";
            this.getTwig().e("Already logged out", new Object[0]);
            this.eventBus.post((Object)new SdkLogoutSuccessEvent("Already logged out"));
        }
    }

    @Override
    public void replay(final String conferenceId, final long offset) {
        this.listenerMode = true;
        this.setListenerMode(false);
        Observable<ReplayConferenceEvent> user = this.conference_observable_provider.getReplayObservable(conferenceId, new SdkConferenceReplayBody(offset));
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ReplayConferenceEvent>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Failed to replay conference", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ReplayConferenceErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(ReplayConferenceEvent response) {
                AbstractConferenceSdkService.this.getTwig().i("Success server answer for replaying conference with id: " + conferenceId + "at offset: " + offset, new Object[0]);
                AbstractConferenceSdkService.this.join(response.getConferenceId());
            }
        });
    }

    public void startRecording() {
        Validate.notNull(this.conferenceId, "conference Id");
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.getStartRecordingObservable(this.conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Failed to start conference recording", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new StartRecordingResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
            }

            public void onNext(Response<ResponseBody> response) {
                if (response.code() == 200) {
                    AbstractConferenceSdkService.this.getTwig().i("IConference recording started ", new Object[0]);
                }
                AbstractConferenceSdkService.this.eventBus.post((Object)new StartRecordingResultEvent(response.code() == 200));
            }
        });
    }

    public void stopRecording() {
        Validate.notNull(this.conferenceId, "conference Id");
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.getStopRecordingObservable(this.conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Failed to cancel conference recording", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new StopRecordingResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
            }

            public void onNext(Response<ResponseBody> response) {
                if (response.code() == 200) {
                    AbstractConferenceSdkService.this.getTwig().i("Conference recording stopped", new Object[0]);
                }
                AbstractConferenceSdkService.this.eventBus.post((Object)new StopRecordingResultEvent(response.code() == 200));
            }
        });
    }

    @Override
    public boolean muteConference(boolean mute) {
        if (mute && this.media != null && !this.media.isMuted()) {
            this.twig.i("Conference muted", new Object[0]);
            this.media.muteRecording();
        } else if (this.media != null) {
            this.twig.i("Conference unmuted", new Object[0]);
            this.media.unMuteRecording();
        }
        return true;
    }

    @Override
    public boolean isMuted() {
        return this.media != null && this.media.isMuted();
    }

    @Override
    public boolean isUserMuted(String userId) {
        DefaultConferenceUser user = this.findUserById(userId);
        return user != null && user.isMuted();
    }

    @Override
    public void getConferenceStatus(String conferenceId) {
        Observable<GetConferenceStatusEvent> user = this.conference_observable_provider.getConferenceStatusObservable(conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<GetConferenceStatusEvent>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Error while getting conference history", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new GetConferenceStatusErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(GetConferenceStatusEvent response) {
                for (DefaultConferenceUser conferenceUser : response.getConferenceUsers()) {
                    AbstractConferenceSdkService.this.getTwig().e(conferenceUser.getUserId() + " / " + conferenceUser.getStatus(), new Object[0]);
                }
                AbstractConferenceSdkService.this.getTwig().i("Dispatching conference status result", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)response);
            }
        });
    }

    @Override
    public String getCurrentConferenceId() {
        Validate.runningOnUiThread();
        if (this.conference != null && this.conference.getConferenceId() != null) {
            return this.conference.getConferenceId();
        }
        return this.conferenceId;
    }

    @Override
    public int getConferenceRoomSize() {
        if (this.conference != null) {
            return this.conference.getConferenceRoomSize();
        }
        return 0;
    }

    @Override
    public void conferenceHistory(String conferenceId) {
        Observable<List<HistoryConference>> user = this.conference_observable_provider.getConferenceHistoryObservable(conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<HistoryConference>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Error while retrieving conference history", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new GetConferenceHistoryErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(List<HistoryConference> response) {
                AbstractConferenceSdkService.this.getTwig().i("Dispatching conference history response", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new GetConferenceHistoryEvent(response));
            }
        });
    }

    @Override
    public String currentSpeaker() {
        if (this.media == null || this.conference == null || this.conference.getConferenceUsers() == null) {
            return VoxeetPreferences.id();
        }
        String currentSpeaker = null;
        for (DefaultConferenceUser user : this.conference.getConferenceUsers()) {
            if (user.getUserId() == null) continue;
            int peerVuMeter = this.media.getPeerVuMeter(user.getUserId());
            if (currentSpeaker != null && (peerVuMeter <= 100 || this.media.getPeerVuMeter(currentSpeaker) >= peerVuMeter)) continue;
            currentSpeaker = user.getUserId();
        }
        return currentSpeaker;
    }

    @Override
    public int getSdkPeerVuMeter(String peerId) {
        Validate.runningOnUiThread();
        if (this.media != null) {
            return this.media.getPeerVuMeter(peerId);
        }
        return 0;
    }

    public DefaultConferenceUser findUserById(final String userId) {
        Validate.notNull(userId, "user id");
        if (this.conference != null && this.conference.getConferenceUsers() != null) {
            return (DefaultConferenceUser)Iterables.find((Iterable)this.conference.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

                public boolean apply(DefaultConferenceUser input) {
                    return userId.equalsIgnoreCase(input.getUserId());
                }
            }, null);
        }
        return null;
    }

    @Override
    public boolean muteUser(String userId, boolean shouldMute) {
        Validate.notNull(userId, "user id");
        Validate.runningOnUiThread();
        DefaultConferenceUser user = this.findUserById(userId);
        if (user != null) {
            float muteValue = shouldMute ? 10000.0f : 1.0f;
            this.startTransactionConferenceUser();
            user.setMuted(shouldMute);
            this.getTwig().i("Setting mute property for conference participant with id " + userId + " to " + shouldMute, new Object[0]);
            this.media.changePeerGain(userId, muteValue);
            this.commitTransactionConferenceUser();
            return true;
        }
        return false;
    }

    @Override
    public String getAliasId() {
        return this.conferenceAlias;
    }

    @Override
    public void switchCamera() {
        Validate.notNull(this.media, "media");
        this.media.switchCamera(new VideoCapturerAndroid.CameraSwitchHandler(){

            public void onCameraSwitchDone(boolean isFrontCamera) {
                AbstractConferenceSdkService.this.getTwig().i("Successfully switched camera", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
            }

            public void onCameraSwitchError(String errorDescription) {
                AbstractConferenceSdkService.this.getTwig().e("Failed to switch camera", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new CameraSwitchErrorEvent(errorDescription));
            }
        });
    }

    @Override
    public String getConferenceId() {
        return this.conferenceId;
    }

    @Override
    public List<Media.AudioRoute> getAvailableRoutes() {
        return this.media != null ? this.media.availableRoutes() : new ArrayList();
    }

    @Override
    public Media.AudioRoute currentRoute() {
        Media.AudioRoute route = Media.AudioRoute.ROUTE_PHONE;
        if (this.media != null) {
            route = this.media.outputRoute();
        }
        return route;
    }

    @Override
    public boolean setAudioRoute(Media.AudioRoute route) {
        Validate.runningOnUiThread();
        if (this.media != null) {
            this.getTwig().i("Changing audio route to " + route, new Object[0]);
            this.media.setOutputRoute(route);
            return true;
        }
        return false;
    }

    @Override
    public void subscribe(String conferenceId) {
        Observable<SubscribeConference> user = this.conference_observable_provider.getSubscribeObservable(conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<SubscribeConference>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Failed to subscribe to this conference's events", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new SubscribeConferenceErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(SubscribeConference response) {
                AbstractConferenceSdkService.this.getTwig().i("You are no subscribed to this conference's events", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new SubscribeConferenceEvent(response));
            }
        });
    }

    @Override
    public void unSubscribe() {
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.getUnSubscribeObservable(this.conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Failed to unsubscribe from this conference's events", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new UnSubscribeConferenceAnswerEvent(false, AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(Response<ResponseBody> response) {
                AbstractConferenceSdkService.this.getTwig().i("You are no longer subscribed to this conference's events", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new UnSubscribeConferenceAnswerEvent(response.code() == 200));
            }
        });
    }

    @Override
    public void join(final String conferenceId) {
        Validate.notNull(conferenceId, "conference Id");
        this.removeTimeoutCallbacks();
        if (this.inConference) {
            this.twig.e("Already joining/joined a conference", new Object[0]);
            return;
        }
        this.inConference = true;
        this.conferenceId = conferenceId;
        this.initMedia();
        Observable<ResumeConference> user = this.conference_observable_provider.joinConference(conferenceId, new DeviceEvent(DeviceType.ANDROID, this.listenerMode));
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ResumeConference>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                AbstractConferenceSdkService.this.getTwig().e("Failed to Join conference with id " + conferenceId, new Object[0]);
                AbstractConferenceSdkService.this.inConference = false;
                AbstractConferenceSdkService.this.closeMedia();
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceJoinedError(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(ResumeConference response) {
                if (AbstractConferenceSdkService.this.conference == null) {
                    AbstractConferenceSdkService.this.conference = AbstractConferenceSdkService.this.createConference();
                }
                AbstractConferenceSdkService.this.conference.setConferenceId(response.getConferenceId());
                AbstractConferenceSdkService.this.conference.setConferenceAlias(response.getConferenceId());
                AbstractConferenceSdkService.this.conferenceId = AbstractConferenceSdkService.this.conference.getConferenceId();
                AbstractConferenceSdkService.this.conferenceAlias = AbstractConferenceSdkService.this.conference.getConferenceAlias();
                if (response.getConferenceId() != null) {
                    AbstractConferenceSdkService.this.conferenceId = response.getConferenceId();
                }
                if (response.getConferenceAlias() != null) {
                    AbstractConferenceSdkService.this.conferenceAlias = response.getConferenceAlias();
                }
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferencePreJoinedEvent(AbstractConferenceSdkService.this.getConferenceId(), AbstractConferenceSdkService.this.getAliasId()));
                AbstractConferenceSdkService.this.inConference = true;
                AbstractConferenceSdkService.this.setAudioRoute(Media.AudioRoute.ROUTE_PHONE);
                AbstractConferenceSdkService.this.getTwig().i("Joined conference with id " + AbstractConferenceSdkService.this.getConferenceId(), new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceJoinedSuccessEvent(AbstractConferenceSdkService.this.getConferenceId(), AbstractConferenceSdkService.this.getAliasId()));
            }
        });
    }

    @Override
    public EglBase.Context getEglContext() {
        Validate.notNull(this.eglBase, "egl base");
        return this.eglBase.getEglBaseContext();
    }

    @Override
    public boolean setTimeOut(long timeout) {
        this.getTwig().i("Timeout set to " + timeout, new Object[0]);
        this.timeOutTimer = timeout;
        return true;
    }

    @Override
    public long getTimeout() {
        return this.timeOutTimer;
    }

    @Override
    public void getInvitedUsers() {
        Observable<GetConferenceStatusEvent> user = this.conference_observable_provider.getConferenceStatusObservable(this.conferenceId);
        user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<GetConferenceStatusEvent>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Error while retrieving connecting users", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceUsersInvitedEvent(null));
            }

            public void onNext(GetConferenceStatusEvent response) {
                Iterable users = Iterables.filter(response.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

                    public boolean apply(DefaultConferenceUser input) {
                        return input.getStatus().equalsIgnoreCase(ConferenceUserStatus.CONNECTING.toString());
                    }
                });
                AbstractConferenceSdkService.this.twig.i("Successfully retrieved connecting users", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceUsersInvitedEvent(users));
            }
        });
    }

    protected void answer(final String peer, SdpMessage message) {
        Validate.notNull(this.conferenceId, "conference Id");
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.answerConference(this.conferenceId, peer, message.getDescription());
        user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("Offer created for " + peer + " : KO", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new ParticipantAddedErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
            }

            public void onNext(Response<ResponseBody> response) {
                if (response.code() != 200) {
                    AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : KO", new Object[0]);
                    AbstractConferenceSdkService.this.eventBus.post((Object)new ParticipantAddedErrorEvent(response.code() + ""));
                } else {
                    AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : OK", new Object[0]);
                }
            }
        });
    }

    @Override
    public void sendBroadcastMessage(String message) {
        Validate.notNull(this.conferenceId, " conference Id");
        Validate.notNull(message, "message");
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.broadcastMessage(this.conferenceId, new BroadcastEvent(message));
        user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("The broadcast message has not been sent", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new SendBroadcastResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
            }

            public void onNext(Response<ResponseBody> response) {
                AbstractConferenceSdkService.this.getTwig().i("The broadcast message has been sent", new Object[0]);
                AbstractConferenceSdkService.this.eventBus.post((Object)new SendBroadcastResultEvent(response.code() == 200));
            }
        });
    }

    @Override
    public void leave() {
        this.getTwig().i("Attempting to leave conference with conference id " + this.conferenceId, new Object[0]);
        Observable<Response<ResponseBody>> user = this.conference_observable_provider.leaveConference(this.conferenceId);
        user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){
            private boolean success = false;

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                AbstractConferenceSdkService.this.getTwig().e("having throwable", e);
                e.printStackTrace();
                AbstractConferenceSdkService.this.getTwig().e("Something went wrong while leaving the conference", new Object[0]);
                AbstractConferenceSdkService.this.closeMedia();
                if (!this.success) {
                    AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceLeftError(AbstractConferenceSdkService.this.handleError(e)));
                }
            }

            public void onNext(Response<ResponseBody> response) {
                AbstractConferenceSdkService.this.getTwig().i("Conference left successfully", new Object[0]);
                int leftInConference = 0;
                DefaultConference conference = AbstractConferenceSdkService.this.getConference();
                if (conference != null) {
                    leftInConference = AbstractConferenceSdkService.this.getConference().getConferenceUsers().size() - 1;
                }
                AbstractConferenceSdkService.this.closeMedia();
                if (response.code() == 200 || response.code() == 404) {
                    AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceLeftSuccessEvent(leftInConference));
                    this.success = true;
                } else {
                    AbstractConferenceSdkService.this.eventBus.post((Object)new ConferenceLeftError(response.code() + ""));
                }
            }
        });
    }

    protected void closeMedia() {
        if (this.media != null) {
            try {
                if (this.conference != null) {
                    for (DefaultConferenceUser user : this.conference.getConferenceUsers()) {
                        if (user == null || user.getUserId() == null) continue;
                        this.media.removePeer(user.getUserId());
                    }
                }
            }
            catch (Exception ex) {
                this.twig.e(ex);
            }
            finally {
                this.media.stop();
                this.media = null;
                this.isMicrophoneOn = true;
                this.getTwig().i("Microphone value restored to true", new Object[0]);
                this.isVideoOn = false;
                this.twig.i("Video value restored to false", new Object[0]);
                this.listenerMode = false;
                this.getTwig().i("Listener mode set back to false", new Object[0]);
            }
        }
        this.getTwig().i("Media closed", new Object[0]);
        this.inConference = false;
        this.conference = null;
    }

    protected void handleAnswer(final OfferCreated offer) throws MediaException {
        if (this.media != null) {
            SdpDescription description = new SdpDescription(offer.getDescription().getType(), offer.getDescription().getSdp());
            ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
            for (OfferCandidate candidate : offer.getCandidates()) {
                candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
            }
            this.media.createAnswerForPeer(offer.getUserId(), description.getSsrc(), description, candidates, offer.isMaster(), new PendingPeerCallback(){

                public void onMessage(SdpMessage message) {
                    try {
                        if (AbstractConferenceSdkService.this.conference == null) {
                            AbstractConferenceSdkService.this.conference = AbstractConferenceSdkService.this.createConference();
                        }
                        if (AbstractConferenceSdkService.this.conference == null) {
                            AbstractConferenceSdkService.this.conference = AbstractConferenceSdkService.this.createConference();
                        }
                        if (offer.getUserId().contains("11111")) {
                            AbstractConferenceSdkService.this.conference.getConferenceUsers().add(AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), new UserInfo("Julie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png")));
                        } else if (offer.getUserId().contains("22222")) {
                            AbstractConferenceSdkService.this.conference.getConferenceUsers().add(AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), new UserInfo("Sophie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png")));
                        } else if (offer.getUserId().contains("33333")) {
                            AbstractConferenceSdkService.this.conference.getConferenceUsers().add(AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), new UserInfo("Mike", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png")));
                        } else {
                            AbstractConferenceSdkService.this.conference.getConferenceUsers().add(AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), new UserInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl())));
                        }
                        AbstractConferenceSdkService.this.changePeerPosition(offer.getUserId(), 0.0, 0.5);
                        AbstractConferenceSdkService.this.answer(offer.getUserId(), message);
                    }
                    catch (Exception e) {
                        Log.d((String)AbstractConferenceSdkService.this.TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                    }
                }
            });
        }
    }

    @Override
    public void toggleRecording() {
        if (this.isRecording) {
            this.stopRecording();
        } else {
            this.startRecording();
        }
    }

    @Override
    public boolean changePeerPosition(String userId, double angle, double distance) {
        if (this.media != null) {
            this.media.changePeerPosition(userId, angle, distance);
            return true;
        }
        return false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceived invitation) {
        DefaultConference conference = invitation.getEvent().getConference();
        if (!invitation.getEvent().getUserId().equals(VoxeetPreferences.id()) || conference.getConferenceType().equals(ConferenceType.SCHEDULED.value())) {
            this.getTwig().i("Invitation received from " + invitation.getEvent().getUserId(), new Object[0]);
            this.hasRequestedInvitation = true;
            this.getConferenceStatus(conference.getConferenceId());
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(GetConferenceStatusEvent event) {
        if (!this.isLive() && this.hasRequestedInvitation && event.getConferenceUsers().size() > 0) {
            DefaultConferenceUser conferenceUser = event.getConferenceUsers().get(0);
            HashMap<String, String> infos = new HashMap<String, String>();
            infos.put("ConfId", event.getConferenceId());
            infos.put("ExternalId", conferenceUser.getUserInfo().getExternalId());
            infos.put("DisplayName", conferenceUser.getUserInfo().getName());
            infos.put("AvatarUrl", conferenceUser.getUserInfo().getAvatarUrl());
            this.getTwig().i("Starting default incoming view", new Object[0]);
            Intent intent = VoxeetIntentFactory.buildFrom(this.context, VoxeetPreferences.getDefaultActivity(), infos);
            if (intent != null) {
                this.context.startActivity(intent);
            }
            this.hasRequestedInvitation = false;
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceStartedEvent ownConferenceStartedEvent) {
        if (this.conference == null) {
            this.conference = this.createConference();
        }
        this.getTwig().i("Own conference started", new Object[0]);
        this.conference.setConferenceInfos(ownConferenceStartedEvent.event().getConferenceInfos());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OfferCreatedEvent event) {
        try {
            this.handleAnswer(event.offer());
        }
        catch (MediaException e) {
            e.printStackTrace();
            this.getTwig().e(e);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserAddedEvent event) {
        DefaultConferenceUser user;
        ConferenceUserAdded content = event.getEvent();
        if (null != content && null == (user = this.findUserById(event.getEvent().getUserId()))) {
            user = new DefaultConferenceUser(content.getUserId(), null);
            user.setIsOwner(false);
            user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
            this.conference.getConferenceUsers().add(user);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdatedEvent event) {
        boolean timeout_managed;
        DefaultConferenceUser user = this.findUserById(event.getUserId());
        ConferenceUserStatus status = ConferenceUserStatus.valueOf((String)event.getStatus());
        boolean was_online = false;
        try {
            was_online = ConferenceUserStatus.ON_AIR.equals((Object)user.getConferenceStatus());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setStatus(event.getStatus());
            this.commitTransactionConferenceUser();
        } else {
            this.getTwig().i("Not in conference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
        }
        switch (status) {
            case LEFT: 
            case DECLINE: {
                if (this.media == null || user == null) break;
                this.getTwig().i("In conference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
                this.media.removePeer(event.getUserId());
                break;
            }
            default: {
                this.getTwig().i("status not managed updated to " + event.getStatus(), new Object[0]);
            }
        }
        boolean bl = timeout_managed = this.timeoutRunnable != null && this.timeoutRunnable.isTriggered();
        if (!timeout_managed && ConferenceUserStatus.DECLINE.equals((Object)status) && !event.getUserId().equals(VoxeetPreferences.id())) {
            this.getTwig().i("Conference user with id: " + event.getUserId() + " declined the call", new Object[0]);
            this.eventBus.post((Object)new ConferenceUserCallDeclinedEvent(event.getConfId(), event.getUserId(), event.getStatus()));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAddedEvent event) {
        DefaultConferenceUser user = event.getUser();
        if (user != null) {
            HashMap streams;
            this.twig.i("Conference user joined with id: " + user.getUserId(), new Object[0]);
            MediaStream stream = null;
            if (null != this.media && (streams = this.media.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = (MediaStream)this.media.getMapOfStreams().get(user.getUserId());
            }
            this.eventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPushEvent event) {
        this.closeMedia();
        this.getTwig().i("Conference has ended", new Object[0]);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEndedEvent event) {
        this.closeMedia();
        this.getTwig().i("Conference has ended", new Object[0]);
        this.eventBus.post((Object)event.getEvent());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdatedEvent event) {
        for (DefaultConferenceUser conferenceUser : event.getEvent().getUser()) {
            DefaultConferenceUser user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            this.twig.i("Quality updated for " + user.getUserId(), new Object[0]);
            this.startTransactionConferenceUser();
            user.setQuality(conferenceUser.getQuality());
            this.commitTransactionConferenceUser();
            this.eventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RecordingStatusUpdate event) {
        RecordingStatusUpdateEvent recordingStatusUpdateEvent = event.getEvent();
        DefaultConferenceUser user = this.findUserById(recordingStatusUpdateEvent.getUserId());
        if (user != null) {
            RecordingStatus status = RecordingStatus.valueOf((String)recordingStatusUpdateEvent.getRecordingStatus());
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                this.conference.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.getTimeStamp()));
                this.conference.setRecordingStatus(RecordingStatus.RECORDING);
                this.conference.setRecordingUser(recordingStatusUpdateEvent.getUserId());
                user.setIsRecordingOwner(true);
            } else {
                this.isRecording = false;
                this.conference.setStartRecordTimestamp(null);
                this.conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                this.conference.setRecordingUser(null);
                user.setIsRecordingOwner(false);
            }
        }
        this.getTwig().i("Conference's recording status has changed to: " + event.getEvent().getRecordingStatus(), new Object[0]);
        this.eventBus.post((Object)recordingStatusUpdateEvent);
    }

    public DefaultConference getConference() {
        return this.conference;
    }

    public int getPeerVuMeter(String peerId) {
        Validate.runningOnUiThread();
        if (this.media != null) {
            return this.media.getPeerVuMeter(peerId);
        }
        return 0;
    }

    @Override
    public List<ConferenceUser> getConferenceUsers() {
        List users = this.conference.getConferenceUsers();
        return users;
    }

    @Override
    public boolean isLive() {
        return this.conference != null;
    }

    @Override
    public boolean isListenerMode() {
        return this.listenerMode;
    }

    @Override
    public void onCreationSuccess(String conferenceId) {
        this.join(conferenceId);
    }

    protected abstract DefaultConference createConference();

    protected abstract DefaultConferenceUser createConferenceUser(String var1, String var2, UserInfo var3);

    protected Twig getTwig() {
        return this.twig;
    }

    protected void setConference(DefaultConference conference) {
        this.conference = conference;
        this.conferenceId = conference.getConferenceId();
    }

    protected void setConferenceAlias(String alias) {
        this.conferenceAlias = alias;
    }

    protected EventBus getEventBus() {
        return this.eventBus;
    }

    protected ConferenceListener getConferenceListener() {
        return this.listener;
    }

    protected Media getMedia() {
        return this.media;
    }

    public ConferenceUser getUser(final String userId) {
        if (this.conference != null && this.conference.getConferenceUsers() != null) {
            return (ConferenceUser)Iterables.find((Iterable)this.conference.getConferenceUsers(), (Predicate)new Predicate<ConferenceUser>(){

                public boolean apply(ConferenceUser input) {
                    return userId.equals(input.getUserId());
                }
            }, null);
        }
        return null;
    }

    protected VoxeetSdkTemplate getVoxeetSDK() {
        return this.sdk;
    }

    protected abstract void startTransactionConferenceUser();

    protected abstract void commitTransactionConferenceUser();

    @NonNull
    public HashMap<String, MediaStream> getMapOfStreams() {
        return this.media != null ? this.media.getMapOfStreams() : new HashMap<String, MediaStream>();
    }

    private void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    private void sendTimeoutCallbacks() {
        if (this.timeOutTimer != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.getTwig(), this.eventBus, this.timeOutTimer);
            this.getTwig().i("scheduling timer to leave the conference in " + this.timeOutTimer, new Object[0]);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.timeOutTimer);
        }
    }

    public AbstractConferenceSdkService<T, COP, DemoEvent> cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }
}

