package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

import voxeet.com.sdk.events.BaseEvent;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.SdkParticipant;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

/**
 * Created by RomainB on 5/30/16.
 */
public class GetConferenceStatusEvent extends BaseEvent {

    private String conferenceId;

    private String aliasId;

    private long startTimestamp;

    @JsonProperty("isLive")
    private boolean live;

    private String type;

    private List<SdkParticipant> participants;

    public List<DefaultConferenceUser> getConferenceUsers() {
        List<DefaultConferenceUser> users = new ArrayList<>();
        for (SdkParticipant participant : participants) {
            DefaultConferenceUser user = new DefaultConferenceUser(participant.getUserId(),
                    null, new voxeet.com.sdk.json.UserInfo(participant.getMetadata().getExternalName(),
                    participant.getUserId(), participant.getMetadata().getExternalPhotoUrl()));
            user.setConferenceStatusToString(participant.getStatus());
            user.setStatus(participant.getStatus());
            user.setConferenceStatus(ConferenceUserStatus.valueOf(participant.getStatus()));
            users.add(user);
        }
        return users;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getAliasId() {
        return aliasId;
    }

    public void setAliasId(String aliasId) {
        this.aliasId = aliasId;
    }

    public long getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setParticipants(List<SdkParticipant> participants) {
        this.participants = participants;
    }
}
