package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import voxeet.com.sdk.models.impl.DefaultMeetingEvent;

@JsonTypeName(EventNames.MEETING_EVENT_ADDED_OR_UPDATED)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MeetingEventAddedOrUpdatedEvent extends Event {

    private DefaultMeetingEvent meetingEvent;

    public DefaultMeetingEvent getMeetingEvent() {
        return meetingEvent;
    }

    public void setMeetingEvent(DefaultMeetingEvent meetingEvent) {
        this.meetingEvent = meetingEvent;
    }

    @Override
    public String getType() {
        return EventNames.MEETING_EVENT_ADDED_OR_UPDATED;
    }
}
