package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.GRAND_TYPE)
public class GrandTypeEvent extends Event {

    @JsonProperty("grant_type")
    private String grandType;

    public GrandTypeEvent(String grandType) {
        this.grandType = grandType;
    }

    public String getGrandType() {
        return grandType;
    }

    public void setGrandType(String grandType) {
        this.grandType = grandType;
    }

    @Override
    public String getType() {
        return EventNames.GRAND_TYPE;
    }
}
