package voxeet.com.sdk.events.success;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;

import voxeet.com.sdk.events.SuccessEvent;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

/**
 * Created by RomainBenmansour on 4/18/16.
 */
public class ConferenceUserUpdatedEvent extends SuccessEvent {

    @NonNull
    private DefaultConferenceUser user;

    @Nullable
    private MediaStream mediaStream;

    public ConferenceUserUpdatedEvent(@NonNull DefaultConferenceUser user) {
        this.user = user;
    }

    public ConferenceUserUpdatedEvent(@NonNull DefaultConferenceUser user, @NonNull MediaStream stream) {
        this.user = user;

        this.mediaStream = stream;
    }

    @Nullable
    public MediaStream getMediaStream() {
        return mediaStream;
    }

    public void setMediaStream(@NonNull MediaStream mediaStream) {
        this.mediaStream = mediaStream;
    }

    @NonNull
    public DefaultConferenceUser getUser() {
        return user;
    }

    public void setUser(@NonNull DefaultConferenceUser user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + " " + user + " " + mediaStream;
    }
}
