package voxeet.com.sdk.factories;

import android.util.Log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

import voxeet.com.sdk.json.Event;

/**
 * Created by kevinleperf on 12/11/2017.
 */

public class EventsFactory {
    private static final String TAG = EventsFactory.class.getSimpleName();

    private EventsFactory() {

    }

    public static Event decode(String message) {
        ObjectMapper om = new ObjectMapper();
        Event command = null;
        try {
            command = om.readValue(message, Event.class);
        } catch (IOException e) {
            Log.e(Event.TAG, "failed to decode command", e);
        }
        return command;
    }

    public static String getJson(Event event) {
        Log.d("EVENT", event.getClass().getSimpleName());
        ObjectMapper om = new ObjectMapper();
        try {
            return om.writeValueAsString(event);
        } catch (JsonProcessingException e) {
            Log.e(TAG, "failed to send command", e);
            return null;
        }
    }


}
