package voxeet.com.sdk.audio;

import java.util.UUID;

public class ActiveUserState implements AudioUserState {

	private final AudioSession audioSession;
	private final UUID userId;
	private final long ssrc;

	private AudioPosition position;
	
	public ActiveUserState(AudioSession audioSession, UUID userId, long ssrc) {
		this.audioSession = audioSession;
		this.userId = userId;
		this.ssrc = ssrc;
		this.position = DEFAULT_POSITION;
	}
	
	@Override
	public void updatePosition(double angle, double distance) {
        position = new AudioPosition(angle, distance);
		audioSession.updatePosition(userId, position.angle(), position.distance());
	}
	
	@Override
	public void updateGain(float gain) {
		audioSession.updateGain(userId, gain);
	}

	@Override
	public AudioPosition position() {
		return position;
	}

}
