/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import retrofit2.adapter.rxjava.HttpException;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.core.VoxeetPreferences;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.IUserRService;
import voxeet.com.sdk.core.services.AbstractVoxeetClientService;
import voxeet.com.sdk.events.error.GetUploadTokenErrorEvent;
import voxeet.com.sdk.events.error.NewLoginRequiredEvent;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;

public class UserService
extends AbstractVoxeetClientService<IUserRService> {
    public UserService(VoxeetSdkTemplate instance) {
        super(instance, instance.getRetrofit().create(IUserRService.class));
    }

    public final void getUploadToken() {
        Observable<GetTokenUploadSuccessEvent> user = ((IUserRService)this.getService()).getUploadToken();
        user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<GetTokenUploadSuccessEvent>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                if (e instanceof HttpException && ((HttpException)e).response().code() == 403) {
                    UserService.this.eventBus.post((Object)new NewLoginRequiredEvent("New login required"));
                }
                UserService.this.eventBus.post((Object)new GetUploadTokenErrorEvent(UserService.this.handleError(e)));
            }

            public void onNext(GetTokenUploadSuccessEvent response) {
                UserService.this.eventBus.post((Object)response);
                VoxeetPreferences.setUploadToken(response.getUploadToken());
            }
        });
    }

    public static interface UserServiceListener {
        public void onLoginSuccess(String var1);

        public void onLogoutSucesss();
    }
}

