/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.manager.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.utils.__Call;

public class BluetoothDisconnectListener {
    @Nullable
    private final BluetoothAdapter bluetoothAdapter;
    @NonNull
    private final __Call<Boolean> closeBluetoothDevices;
    @Nullable
    private BroadcastReceiver bluetoothStateBroadcastReceiver;

    public BluetoothDisconnectListener(@NonNull Context context, @NonNull __Call<Boolean> closeBluetoothDevices) {
        this.closeBluetoothDevices = closeBluetoothDevices;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (null == this.bluetoothAdapter) {
            return;
        }
        this.bluetoothStateBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                    BluetoothDisconnectListener.this.checkBluetoothStateOff();
                }
            }
        };
        context.registerReceiver(this.bluetoothStateBroadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
    }

    private void checkBluetoothStateOff() {
        if (null == this.bluetoothAdapter) {
            return;
        }
        switch (this.bluetoothAdapter.getState()) {
            case 10: 
            case 13: {
                this.closeBluetoothDevices.apply(true);
                break;
            }
        }
    }
}

