/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.ConnectionStatesEvent;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.promise.Promise;

public abstract class MediaDevice<TYPE> {
    @NonNull
    protected final String id;
    @Nullable
    protected final String name;
    @Nullable
    protected TYPE holder;
    @NonNull
    private final IMediaDeviceConnectionState mediaDeviceConnectionState;
    @NonNull
    private final DeviceType deviceType;
    @NonNull
    protected ConnectionState connectionState = ConnectionState.DISCONNECTED;
    @NonNull
    protected ConnectionState platformConnectionState = ConnectionState.CONNECTED;

    protected MediaDevice(@NonNull IMediaDeviceConnectionState mediaDeviceConnectionState, @NonNull DeviceType deviceType, @NonNull String id) {
        this(mediaDeviceConnectionState, deviceType, id, null);
    }

    protected MediaDevice(@NonNull IMediaDeviceConnectionState mediaDeviceConnectionState, @NonNull DeviceType deviceType, @NonNull String id, @Nullable TYPE holder) {
        this(mediaDeviceConnectionState, deviceType, id, holder, null);
    }

    protected MediaDevice(@NonNull IMediaDeviceConnectionState mediaDeviceConnectionState, @NonNull DeviceType deviceType, @NonNull String id, @Nullable TYPE holder, @Nullable String name) {
        this.mediaDeviceConnectionState = mediaDeviceConnectionState;
        this.id = id;
        this.name = name;
        this.deviceType = deviceType;
        this.holder = holder;
    }

    @NonNull
    public String id() {
        return this.id;
    }

    @NonNull
    public String name() {
        return null != this.name ? this.name : this.id();
    }

    @NonNull
    public DeviceType deviceType() {
        return this.deviceType;
    }

    void setConnectionState(@NonNull ConnectionState connectionState) {
        Log.d(MediaDevice.class.getSimpleName(), "setConnectionState: " + this.id() + " " + (Object)((Object)connectionState));
        this.connectionState = connectionState;
        this.mediaDeviceConnectionState.onConnectionState(new ConnectionStatesEvent(connectionState, this.platformConnectionState, this));
    }

    protected void setPlatformConnectionState(@NonNull ConnectionState platformConnectionState) {
        Log.d(MediaDevice.class.getSimpleName(), "setPlatformConnectionState: " + this.id() + " " + (Object)((Object)this.connectionState));
        this.platformConnectionState = platformConnectionState;
        this.mediaDeviceConnectionState.onConnectionState(new ConnectionStatesEvent(this.connectionState, platformConnectionState, this));
    }

    @NonNull
    public ConnectionState connectionState() {
        return this.connectionState;
    }

    @NonNull
    public ConnectionState platformConnectionState() {
        return this.platformConnectionState;
    }

    @NonNull
    protected abstract Promise<Boolean> connect();

    @NonNull
    protected abstract Promise<Boolean> disconnect();
}

