/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2;

import android.content.Context;
import android.support.annotation.NonNull;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio.utils.__Call;
import com.voxeet.audio.utils.__Opt;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.description.ConnectionStatesEvent;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.manager.BluetoothHeadsetDeviceManager;
import com.voxeet.audio2.manager.ConnectScheduler;
import com.voxeet.audio2.manager.IDeviceManager;
import com.voxeet.audio2.manager.SystemDeviceManager;
import com.voxeet.audio2.manager.WiredHeadsetDeviceManager;
import com.voxeet.audio2.system.SystemAudioManager;
import com.voxeet.promise.AbstractPromise;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.promise.solve.params.Reject;
import java.util.ArrayList;
import java.util.List;

public class AudioDeviceManager
implements IDeviceManager<MediaDevice> {
    private __Call<Promise<List<MediaDevice>>> update;
    private ConnectScheduler connectScheduler;
    private static final String TAG = AudioDeviceManager.class.getSimpleName();
    private SystemAudioManager systemAudioManager;
    private SystemDeviceManager systemDeviceManager;
    private WiredHeadsetDeviceManager wiredHeadsetDeviceManager;
    private BluetoothHeadsetDeviceManager bluetoothHeadsetDeviceManager;

    private AudioDeviceManager() {
    }

    public AudioDeviceManager(@NonNull Context context, @NonNull __Call<Promise<List<MediaDevice>>> update) {
        this.systemAudioManager = new SystemAudioManager(context);
        this.update = update;
        this.systemDeviceManager = new SystemDeviceManager(this.systemAudioManager, this::onConnectionState);
        this.wiredHeadsetDeviceManager = new WiredHeadsetDeviceManager(context, this.systemAudioManager, r -> this.sendUpdate(), this::onConnectionState);
        this.bluetoothHeadsetDeviceManager = new BluetoothHeadsetDeviceManager(context, this, this.systemAudioManager, r -> this.sendUpdate(), this::onConnectionState);
        this.connectScheduler = new ConnectScheduler();
    }

    @NonNull
    public SystemAudioManager systemAudioManager() {
        return this.systemAudioManager;
    }

    @NonNull
    public SystemDeviceManager systemDeviceManager() {
        return this.systemDeviceManager;
    }

    @NonNull
    public BluetoothHeadsetDeviceManager bluetoothHeadsetDeviceManager() {
        return this.bluetoothHeadsetDeviceManager;
    }

    public void dump(@NonNull List<MediaDevice> list) {
        Log.d(TAG, ">>>>>>>>>>>>>>>>>>>>>>>>>>>");
        Log.d(TAG, "enumeraDevices");
        for (MediaDevice device : list) {
            Log.d(TAG, "device " + device.id() + " " + (Object)((Object)device.connectionState()));
        }
        Log.d(TAG, "<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    @Override
    @NonNull
    public Promise<List<MediaDevice>> enumerateDevices() {
        return this.enumerateTypedDevices();
    }

    @Override
    @NonNull
    public Promise<List<MediaDevice>> enumerateTypedDevices() {
        return new Promise((resolve, reject) -> Promise.all((AbstractPromise[])new AbstractPromise[]{this.systemDeviceManager.enumerateDevices(), this.wiredHeadsetDeviceManager.enumerateDevices(), this.bluetoothHeadsetDeviceManager.enumerateDevices()}).then((result, solver) -> {
            ArrayList<MediaDevice> list = new ArrayList<MediaDevice>();
            for (List mediaDevices : (List)__Opt.of(result).or(new ArrayList())) {
                if (null == mediaDevices) continue;
                list.addAll(mediaDevices);
            }
            this.dump(list);
            resolve.call(list);
        }).error(arg_0 -> ((Reject)reject).call(arg_0)));
    }

    @Override
    public boolean isWorking() {
        return true;
    }

    @NonNull
    public Promise<List<MediaDevice>> enumerateDevices(@NonNull DeviceType deviceType) {
        return new Promise(solver -> this.enumerateDevices().then(devices -> solver.resolve(this.filter((List<MediaDevice>)devices, deviceType))).error(arg_0 -> ((Solver)solver).reject(arg_0)));
    }

    @NonNull
    public List<MediaDevice> filter(@NonNull List<MediaDevice> devices, @NonNull DeviceType deviceType) {
        ArrayList<MediaDevice> result = new ArrayList<MediaDevice>();
        for (MediaDevice device : (List)__Opt.of(devices).or(new ArrayList())) {
            if (!deviceType.equals((Object)device.deviceType())) continue;
            result.add(device);
        }
        return result;
    }

    public boolean isLockedForConnectivity() {
        return this.connectScheduler.isLocked();
    }

    @NonNull
    public Promise<Boolean> connect(@NonNull MediaDevice mediaDevice) {
        return new Promise(solver -> this.connectScheduler.waitFor().then(connectScheduler -> connectScheduler.pushConnect(mediaDevice, (Solver<Boolean>)solver)).error(Throwable::printStackTrace));
    }

    @NonNull
    public Promise<Boolean> disconnect(@NonNull MediaDevice mediaDevice) {
        return new Promise(solver -> this.connectScheduler.waitFor().then(connectScheduler -> connectScheduler.pushDisconnect(mediaDevice, (Solver<Boolean>)solver)).error(Throwable::printStackTrace));
    }

    @NonNull
    public Promise<MediaDevice> current() {
        return new Promise(solver -> this.connectScheduler.waitFor().then(result -> solver.resolve((Object)this.connectScheduler.current())).error(arg_0 -> ((Solver)solver).reject(arg_0)));
    }

    private void onConnectionState(@NonNull ConnectionStatesEvent holder) {
        this.sendUpdate();
    }

    public boolean isWiredConnected() {
        return this.wiredHeadsetDeviceManager.isConnected();
    }

    private void sendUpdate() {
        this.update.apply(this.enumerateDevices());
    }
}

