/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.description.ConnectionState;
import java.util.List;

public class MediaDeviceHelper {
    public static boolean isWiredHeadsetConnected(@NonNull AudioManager manager) {
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] audioDevices;
            for (AudioDeviceInfo deviceInfo : audioDevices = manager.getDevices(3)) {
                switch (deviceInfo.getType()) {
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
            }
        }
        return manager.isWiredHeadsetOn();
    }

    public static boolean hasConnected(List<MediaDevice> list) {
        if (null == list) {
            return false;
        }
        for (MediaDevice device : list) {
            if (!ConnectionState.CONNECTED.equals((Object)device.connectionState)) continue;
            return true;
        }
        return false;
    }
}

