/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.system.record;

import android.media.AudioRecord;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.system.log.Logging;
import com.voxeet.system.record.AudioEffects;
import com.voxeet.system.record.AudioRecordStartErrorCode;
import com.voxeet.system.record.AudioRecordThread;
import com.voxeet.system.record.IMicrophoneInformationProvider;
import com.voxeet.system.record.IMicrophoneRecordStateListener;
import com.voxeet.system.record.MicrophoneRecordState;
import java.nio.ByteBuffer;

public class MicrophoneRecord {
    private static final String TAG = MicrophoneRecord.class.getSimpleName();
    public static final int BITS_PER_SAMPLE = 16;
    public static final int DEFAULT_SAMPLE_RATE = 48000;
    public static final int CALLBACK_BUFFER_SIZE_MS = 10;
    public static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    public static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE = 7;
    private final int audioSource;
    private final IMicrophoneInformationProvider informationProvider;
    private final AudioEffects effects;
    private IMicrophoneRecordStateListener stateListener;
    private MicrophoneRecordState state;
    @Nullable
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    public static boolean activated = true;
    private boolean microphoneMute = false;
    private AudioRecordThread.AudioRecordSampleListener listenerAudioRecordSampleListener;

    public MicrophoneRecord(int audioSource, @NonNull IMicrophoneRecordStateListener stateListener, @NonNull IMicrophoneInformationProvider informationProvider, @NonNull AudioRecordThread.AudioRecordSampleListener listenerAudioRecordSampleListener, @Nullable AudioEffects effects) {
        this.stateListener = stateListener;
        this.listenerAudioRecordSampleListener = listenerAudioRecordSampleListener;
        this.effects = effects;
        this.informationProvider = informationProvider;
        this.audioSource = audioSource;
    }

    public int initRecording(int sampleRate, int channels) {
        this.setState(MicrophoneRecordState.INITIALIZING);
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        if (this.audioRecord != null) {
            this.informationProvider.reportInitError("InitRecording called twice without StopRecording.");
            this.setState(MicrophoneRecordState.INITIALIZED_FAILED);
            return -1;
        }
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        if (!this.byteBuffer.hasArray()) {
            this.informationProvider.reportInitError("ByteBuffer does not have backing array.");
            this.setState(MicrophoneRecordState.INITIALIZED_FAILED);
            return -1;
        }
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.informationProvider.nativeBufferAddress(this.byteBuffer);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            this.informationProvider.reportInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
            this.setState(MicrophoneRecordState.INITIALIZED_FAILED);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        if (!activated) {
            this.setState(MicrophoneRecordState.INITIALIZED);
            return framesPerBuffer;
        }
        try {
            this.audioRecord = new AudioRecord(this.audioSource, sampleRate, channelConfig, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            this.informationProvider.reportInitError("AudioRecord ctor error: " + e.getMessage());
            this.releaseAudioResources();
            this.setState(MicrophoneRecordState.INITIALIZED_FAILED);
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.informationProvider.reportInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            this.setState(MicrophoneRecordState.INITIALIZED_FAILED);
            return -1;
        }
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        this.setState(MicrophoneRecordState.INITIALIZED);
        return framesPerBuffer;
    }

    public boolean startRecording() {
        this.setState(MicrophoneRecordState.STARTING);
        Logging.d(TAG, "startRecording");
        if (null == this.byteBuffer) {
            this.setState(MicrophoneRecordState.STARTED_ERROR);
            this.setState(MicrophoneRecordState.STOPPED);
            return false;
        }
        if (!activated) {
            this.audioThread = new AudioRecordThread("AudioRecordDeactivatedJavaThread", false, this.audioRecord, this.listenerAudioRecordSampleListener, this.byteBuffer);
            this.audioThread.activate(this.microphoneMute);
            this.audioThread.start();
            return true;
        }
        MicrophoneRecord.assertTrue(this.audioRecord != null);
        MicrophoneRecord.assertTrue(this.audioThread == null);
        try {
            Log.d((String)TAG, (String)"startRecording !");
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.informationProvider.reportStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + e.getMessage());
            this.setState(MicrophoneRecordState.STARTED_ERROR);
            this.setState(MicrophoneRecordState.STOPPED);
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.informationProvider.reportStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            this.setState(MicrophoneRecordState.STARTED_ERROR);
            this.setState(MicrophoneRecordState.STOPPED);
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordDeactivatedJavaThread", false, this.audioRecord, this.listenerAudioRecordSampleListener, this.byteBuffer);
        this.audioThread.start();
        this.setState(MicrophoneRecordState.STARTED);
        return true;
    }

    public boolean stopRecording() {
        this.setState(MicrophoneRecordState.STOPPING);
        Logging.d(TAG, "stopRecording");
        MicrophoneRecord.assertTrue(this.audioThread != null);
        this.audioThread.stopThread();
        Log.d((String)TAG, (String)"stopRecording: >>>>>>>>>>>>>>>>>>>>>>");
        Log.d((String)TAG, (String)"stopRecording: >>>>>>>>>>>>>>>>>>>>>>");
        Log.d((String)TAG, (String)"stopRecording: TODO STILL NEED TO JOIN THREAD ON STOP");
        Log.d((String)TAG, (String)"stopRecording: <<<<<<<<<<<<<<<<<<<<<<");
        Log.d((String)TAG, (String)"stopRecording: <<<<<<<<<<<<<<<<<<<<<<");
        this.audioThread = null;
        if (this.effects != null) {
            this.effects.release();
        }
        this.releaseAudioResources();
        this.setState(MicrophoneRecordState.STOPPED);
        return true;
    }

    public void logMainParameters() {
        if (this.audioRecord != null) {
            Log.d((String)TAG, (String)("AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate()));
        }
    }

    public void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23 && this.audioRecord != null) {
            Log.d((String)TAG, (String)("AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames()));
        }
    }

    static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    public void setMicrophoneMute(boolean mute) {
        Log.w((String)TAG, (String)("setMicrophoneMute(" + mute + ")"));
        this.microphoneMute = mute;
        if (null != this.audioThread) {
            this.audioThread.activate(this.microphoneMute);
        }
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    public MicrophoneRecordState state() {
        return this.state;
    }

    private void setState(@NonNull MicrophoneRecordState state) {
        this.state = state;
        this.stateListener.onState(state);
    }
}

