/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.mode.MediaMode;
import com.voxeet.audio.mode.NormalMode;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.MediaDeviceHelper;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;

public class NormalDevice
extends MediaDevice<DeviceType> {
    @NonNull
    private AudioManager audioManager;
    private AudioFocusManager audioFocusManagerCall = new AudioFocusManager(AudioFocusMode.CALL);
    private AudioFocusManager audioMediaFocusManagerCall = new AudioFocusManager(AudioFocusMode.MEDIA);
    @NonNull
    private NormalMode normalMode;
    private MediaMode mediaMode;

    public NormalDevice(@NonNull AudioManager audioManager, @NonNull IMediaDeviceConnectionState connectionState, @NonNull DeviceType deviceType, @NonNull String id) {
        super(connectionState, deviceType, id);
        this.audioManager = audioManager;
        this.normalMode = new NormalMode(audioManager, this.audioFocusManagerCall);
        this.mediaMode = new MediaMode(audioManager, this.audioMediaFocusManagerCall);
    }

    @Override
    @NonNull
    protected Promise<Boolean> connect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.CONNECTING);
            this.normalMode.apply(false).then(aBoolean -> {
                this.setConnectionState(ConnectionState.CONNECTED);
                solver.resolve((Object)true);
            }).error(error -> {
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.reject(error);
            });
        });
    }

    @Override
    @NonNull
    protected Promise<Boolean> disconnect() {
        return new Promise(solver -> {
            if (ConnectionState.DISCONNECTED.equals((Object)this.connectionState)) {
                solver.resolve((Object)true);
                return;
            }
            this.setConnectionState(ConnectionState.DISCONNECTING);
            this.normalMode.abandonAudioFocus().then(aBoolean -> this.mediaMode.apply(false)).then(o -> {
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)true);
            }).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }

    @Override
    @NonNull
    public DeviceType deviceType() {
        if (MediaDeviceHelper.isWiredHeadsetConnected(this.audioManager) && ConnectionState.CONNECTED.equals((Object)this.connectionState)) {
            return DeviceType.WIRED_HEADSET;
        }
        return super.deviceType();
    }
}

