/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.system.record;

import android.media.AudioRecord;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.system.record.MicrophoneRecord;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class AudioRecordThread
extends Thread {
    private ReentrantLock lock = new ReentrantLock();
    private static final String TAG = AudioRecordThread.class.getSimpleName();
    private CountDownLatch countDownLatch = null;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordSampleListener listener;
    @NonNull
    private ByteBuffer byteBuffer = ByteBuffer.allocate(1);
    private volatile boolean keepAlive = true;
    private boolean activated = true;
    private byte[] emptyBytes = new byte[this.byteBuffer.capacity()];
    private boolean started = false;

    private AudioRecordThread(String name) {
        super(name);
    }

    public AudioRecordThread(String name, boolean activated, @NonNull AudioRecord audioRecord, @NonNull AudioRecordSampleListener listener, @NonNull ByteBuffer byteBuffer) {
        this(name);
        Log.d((String)"AudioRecordThread", (String)("AudioRecordThread: creating a specific AudioRecordThread :: " + activated));
        this.activated = activated;
        this.setAudioRecord(audioRecord);
        this.listener = listener;
        this.byteBuffer = byteBuffer;
    }

    public void activate(boolean activated) {
        this.activated = activated;
    }

    @Override
    public void run() {
        this.started = true;
        Process.setThreadPriority((int)-19);
        Log.d((String)TAG, (String)"AudioRecordThread");
        MicrophoneRecord.assertTrue(null != this.audioRecord && this.audioRecord.getRecordingState() == 3);
        long lastTime = System.nanoTime();
        while (this.keepAlive && null != this.listener) {
            AudioRecordSampleListener listener = this.listener;
            int bytesRead = 0;
            this.lock();
            if (this.activated) {
                bytesRead = this.audioRecord.read(this.byteBuffer, this.byteBuffer.capacity());
            } else {
                bytesRead = this.emptyBytes.length;
                this.byteBuffer.clear();
                this.byteBuffer.put(this.emptyBytes);
            }
            Log.d((String)TAG, (String)("run: read " + bytesRead));
            this.unlock();
            if (bytesRead == this.byteBuffer.capacity()) {
                if (listener.isMicrophoneMuted()) {
                    this.byteBuffer.clear();
                    this.byteBuffer.put(this.emptyBytes);
                }
                if (!this.keepAlive) continue;
                listener.onDataRead(bytesRead);
                byte[] data = Arrays.copyOfRange(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteBuffer.capacity() + this.byteBuffer.arrayOffset());
                listener.onData(data);
                continue;
            }
            String errorMessage = "AudioRecord.read failed: " + bytesRead;
            if (1 == bytesRead) {
                errorMessage = errorMessage + this.byteBuffer.get(0) + " " + this.byteBuffer.capacity();
            }
            Log.e((String)TAG, (String)errorMessage);
            if (bytesRead != -3) continue;
            this.keepAlive = false;
            listener.onReadFailed(errorMessage);
        }
        try {
            if (this.audioRecord != null) {
                this.audioRecord.stop();
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)("AudioRecord.stop failed: " + e.getMessage()));
        }
        this.started = false;
        if (null != this.countDownLatch) {
            this.countDownLatch.countDown();
        }
    }

    public void setAudioRecord(@NonNull AudioRecord audioRecord) {
        this.lock();
        this.audioRecord = audioRecord;
        this.unlock();
    }

    @Override
    public synchronized void start() {
        this.countDownLatch = new CountDownLatch(1);
        super.start();
    }

    public void stopThread() {
        Log.d((String)TAG, (String)"stopThread");
        this.keepAlive = false;
        this.activated = false;
        try {
            if (null != this.countDownLatch && this.started) {
                this.countDownLatch.await(2000L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.countDownLatch = null;
        }
    }

    private void lock() {
        try {
            this.lock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unlock() {
        try {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface AudioRecordSampleListener {
        public boolean isMicrophoneMuted();

        public void onDataRead(int var1);

        public void onData(@NonNull byte[] var1);

        public void onReadFailed(@NonNull String var1);
    }
}

