/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.manager.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.utils.__Opt;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BluetoothHelper {
    public static boolean canFetchActiveDevice(@NonNull BluetoothHeadset headset) {
        return null != BluetoothHelper._getActiveDevice(headset);
    }

    public static boolean canSetActiveDevice(@NonNull BluetoothHeadset headset) {
        return null != BluetoothHelper._setActiveDevice(headset);
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    @Nullable
    public static BluetoothDevice getActiveDevice(@NonNull BluetoothHeadset headset) {
        return __Opt.of(BluetoothHelper._getActiveDevice(headset)).then(m -> BluetoothHelper._invokeGetActiveDevice(headset, m)).orNull();
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    public static boolean setActiveDevice(@NonNull BluetoothHeadset headset, @NonNull BluetoothDevice device) {
        return __Opt.of(BluetoothHelper._setActiveDevice(headset)).then(m -> BluetoothHelper._invokeSetActiveDevice(headset, m, device)).or(false);
    }

    @Nullable
    private static Method _setActiveDevice(@NonNull BluetoothHeadset headset) {
        try {
            Class<?> klass = headset.getClass();
            return klass.getDeclaredMethod("setActiveDevice", BluetoothDevice.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static Method _getActiveDevice(@NonNull BluetoothHeadset headset) {
        try {
            Class<?> klass = headset.getClass();
            return klass.getDeclaredMethod("getActiveDevice", new Class[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static BluetoothDevice _invokeGetActiveDevice(@NonNull BluetoothHeadset headset, @NonNull Method getActiveDevice) {
        try {
            return (BluetoothDevice)getActiveDevice.invoke((Object)headset, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private static boolean _invokeSetActiveDevice(@NonNull BluetoothHeadset headset, @NonNull Method setActiveDevice, @NonNull BluetoothDevice device) {
        try {
            return (Boolean)setActiveDevice.invoke((Object)headset, device);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }
}

