/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.mode.WiredMode;
import com.voxeet.audio.utils.__Call;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.PlatformDeviceConnectionWrapper;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.promise.Promise;

public class WiredDevice
extends MediaDevice<DeviceType> {
    @NonNull
    private AudioManager audioManager;
    private AudioFocusManager audioFocusManagerCall = new AudioFocusManager(AudioFocusMode.CALL);
    @NonNull
    private WiredMode mode;

    public WiredDevice(@NonNull AudioManager audioManager, @NonNull IMediaDeviceConnectionState connectionState, @NonNull DeviceType deviceType, @NonNull String id, @NonNull __Call<PlatformDeviceConnectionWrapper> afterBuild) {
        super(connectionState, deviceType, id);
        this.audioManager = audioManager;
        this.mode = new WiredMode(audioManager, this.audioFocusManagerCall);
        afterBuild.apply(connectionState1 -> {
            this.platformConnectionState = connectionState1;
        });
    }

    @Override
    @NonNull
    protected Promise<Boolean> connect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.CONNECTING);
            this.mode.apply(false).then(aBoolean -> {
                this.setConnectionState(ConnectionState.CONNECTED);
                solver.resolve((Object)true);
            }).error(error -> {
                error.printStackTrace();
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.reject(error);
            });
        });
    }

    @Override
    @NonNull
    protected Promise<Boolean> disconnect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.DISCONNECTING);
            this.mode.apply(false).then(aBoolean -> {
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)true);
            }).error(error -> {
                error.printStackTrace();
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)false);
            });
        });
    }

    public boolean isConnected() {
        return this.mode.isConnected();
    }
}

