/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.mode.MediaMode;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.promise.Promise;

public class NormalMediaDevice
extends MediaDevice<DeviceType> {
    @NonNull
    private AudioManager audioManager;
    private AudioFocusManager focusManager = new AudioFocusManager(AudioFocusMode.MEDIA);
    @NonNull
    private MediaMode mode;

    public NormalMediaDevice(@NonNull AudioManager audioManager, @NonNull IMediaDeviceConnectionState connectionState, @NonNull DeviceType deviceType, @NonNull String id) {
        super(connectionState, deviceType, id);
        this.audioManager = audioManager;
        this.mode = new MediaMode(audioManager, this.focusManager);
    }

    @Override
    @NonNull
    protected Promise<Boolean> connect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.CONNECTING);
            this.mode.apply(false).then(aBoolean -> {
                this.setConnectionState(ConnectionState.CONNECTED);
                solver.resolve((Object)true);
            }).error(error -> {
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.reject(error);
            });
        });
    }

    @Override
    @NonNull
    protected Promise<Boolean> disconnect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.DISCONNECTING);
            this.mode.apply(false).then(aBoolean -> {
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)true);
            }).error(error -> {
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)false);
            });
        });
    }
}

