/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;

public final class Validate {
    public static boolean hasBluetoothPermissions(@NonNull Context context) {
        String permission2 = "android.permission.BLUETOOTH";
        return Validate.hasPermissionInManifest(context, permission2) && !Validate.deniedPermission(context, permission2);
    }

    private static boolean deniedPermission(Context context, String permission2) {
        boolean GRANTED = false;
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) != 0 || context.checkCallingOrSelfPermission(permission2) != 0;
    }

    private static boolean hasPermissionInManifest(@NonNull Context context, @NonNull String permission_to_check) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 4096);
            String[] requestedPermissions = null;
            if (packageInfo != null) {
                requestedPermissions = packageInfo.requestedPermissions;
            }
            if (null != requestedPermissions) {
                for (String permission2 : requestedPermissions) {
                    if (!permission2.equals(permission_to_check)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }
}

