/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.mode;

import android.media.AudioManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.voxeet.audio.MediaDevice;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusManagerAsync;
import com.voxeet.audio.mode.AbstractMode;
import com.voxeet.audio.utils.Log;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;

public class SpeakerMode
extends AbstractMode {
    public SpeakerMode(@NonNull AudioManager manager, @NonNull AudioFocusManager audioFocusManager) {
        super(manager, audioFocusManager, MediaDevice.ROUTE_SPEAKER);
    }

    @Override
    public Promise<Boolean> apply(boolean speaker_state) {
        if ("samsung".equalsIgnoreCase(Build.BRAND)) {
            Log.d("SpeakerMode", "apply samsung");
            return this.applySamsung(speaker_state);
        }
        Log.d("SpeakerMode", "apply non samsung");
        return this.applyNonSamsung(speaker_state);
    }

    @Override
    public Promise<Boolean> requestAudioFocus() {
        return new Promise(solver -> {
            this.forceVolumeControlStream(this.requestFocus);
            this.audioFocusManger.requestAudioFocus(this.manager, this.requestFocus).then(integer -> solver.resolve((Object)true)).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    Promise<Boolean> applyNonSamsung(boolean speaker_state) {
        return new Promise(solver -> AudioFocusManagerAsync.setMode(this.manager, 3, "SpeakerMode").then(aBoolean -> {
            this.manager.setSpeakerphoneOn(speaker_state);
            return this.requestAudioFocus();
        }).then(o -> solver.resolve((Object)true)).error(arg_0 -> ((Solver)solver).reject(arg_0)));
    }

    Promise<Boolean> applySamsung(boolean speaker_state) {
        return new Promise(solver -> {
            Promise<Boolean> mode;
            if (speaker_state) {
                this.manager.setSpeakerphoneOn(true);
                mode = AudioFocusManagerAsync.setMode(this.manager, -1, "SpeakerMode");
            } else {
                this.manager.setSpeakerphoneOn(speaker_state);
                mode = AudioFocusManagerAsync.setMode(this.manager, 3, "SpeakerMode");
            }
            mode.then(aBoolean -> this.requestAudioFocus()).then(aBoolean -> solver.resolve((Object)true)).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }
}

