/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.mode;

import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.audio.MediaDevice;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusManagerAsync;
import com.voxeet.audio.utils.Invoke;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;

public abstract class AbstractMode {
    protected AudioFocusManager audioFocusManger;
    protected AudioManager manager;
    private MediaDevice audioRoute;
    protected int requestFocus = 0;
    private int abandonFocus = 3;

    private AbstractMode() {
    }

    public AbstractMode(@NonNull AudioManager manager, @NonNull AudioFocusManager audioFocusManager, @NonNull MediaDevice audioRoute) {
        this();
        this.manager = manager;
        this.audioFocusManger = audioFocusManager;
        this.audioRoute = audioRoute;
    }

    public abstract Promise<Boolean> apply(boolean var1);

    public abstract Promise<Boolean> requestAudioFocus();

    public abstract boolean isConnected();

    public Promise<Boolean> abandonAudioFocus() {
        return new Promise(solver -> AudioFocusManagerAsync.setMode(this.manager, 0, "AbstractMode").then(aBoolean -> this.audioFocusManger.abandonAudioFocus(this.manager)).then(integer -> {
            this.forceVolumeControlStream(this.abandonFocus);
            solver.resolve((Object)true);
        }).error(arg_0 -> ((Solver)solver).reject(arg_0)));
    }

    protected void forceVolumeControlStream(int volumeMode) {
        Invoke.callVoidIntArg(this.manager, "forceVolumeControlStream", volumeMode);
    }

    public final MediaDevice getAudioRoute() {
        return this.audioRoute;
    }

    public void configureVolumeStream(int requestFocus, int abandonFocus) {
        this.requestFocus = requestFocus;
        this.abandonFocus = abandonFocus;
    }
}

