/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.focus;

import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.voxeet.audio.focus.AudioFocusManagerAsync;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.focus.AudioFocusRequest;
import com.voxeet.audio.utils.Log;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;

@RequiresApi(api=26)
public class AudioFocusRequest26
implements AudioFocusRequest {
    private final AudioAttributes playbackAttributes;
    private static Handler sHandler = new Handler();
    private final AudioManager.OnAudioFocusChangeListener focusRequest;
    private final android.media.AudioFocusRequest focusRequestBuilt;
    private final AudioFocusMode mode;

    @RequiresApi(value=26)
    public AudioFocusRequest26(AudioFocusMode mode) {
        int usage = 2;
        int content = 1;
        this.mode = mode;
        switch (mode) {
            case MEDIA: {
                usage = 1;
                content = 2;
                break;
            }
        }
        this.playbackAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(content).build();
        this.focusRequest = focusChange -> Log.d("AudioFocusRequest", "onAudioFocusChange: " + focusChange);
        this.focusRequestBuilt = new AudioFocusRequest.Builder(1).setAudioAttributes(this.playbackAttributes).setAcceptsDelayedFocusGain(true).setWillPauseWhenDucked(true).setOnAudioFocusChangeListener(this.focusRequest, sHandler).build();
    }

    @Override
    @RequiresApi(api=26)
    public Promise<Integer> requestAudioFocus(@NonNull AudioManager manager, int audioFocusVolumeType) {
        return new Promise(solver -> {
            int new_mode = AudioFocusMode.CALL.equals((Object)this.mode) ? 3 : 0;
            AudioFocusManagerAsync.setMode(manager, new_mode, "AudioFocusRequest").then(aBoolean -> {
                Log.d("AudioFocusRequest", "requestAudioFocus");
                manager.requestAudioFocus(null, audioFocusVolumeType, 1);
                solver.resolve((Object)manager.requestAudioFocus(this.focusRequestBuilt));
            }).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }

    @Override
    @RequiresApi(api=26)
    public Promise<Integer> abandonAudioFocus(@NonNull AudioManager manager) {
        return new Promise(solver -> {
            Log.d("AudioFocusRequest", "abandonAudioFocus");
            int result = manager.abandonAudioFocusRequest(this.focusRequestBuilt);
            solver.resolve((Object)result);
        });
    }
}

