/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.manager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.MediaDeviceConnectionWrapper;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectScheduler {
    private static final String TAG = ConnectScheduler.class.getSimpleName();
    @NonNull
    private final MediaDeviceConnectionWrapper connectionWrapper;
    private List<IOHolder> mediaDevices = new ArrayList<IOHolder>();
    private IOHolder current = null;
    private boolean locked = false;
    private List<Solver<ConnectScheduler>> waitFors = new CopyOnWriteArrayList<Solver<ConnectScheduler>>();

    public ConnectScheduler() {
        this.connectionWrapper = MediaDeviceConnectionWrapper.unique();
    }

    public void pushConnect(MediaDevice mediaDevice, Solver<Boolean> solver) {
        this.cancelAwaitingConnect();
        this.checkDisconnectPrevious(mediaDevice);
        this.mediaDevices.add(new IOHolder(true, mediaDevice, solver));
        this.tryIO();
    }

    public void pushDisconnect(MediaDevice mediaDevice, Solver<Boolean> solver) {
        this.checkDisconnectPrevious(mediaDevice);
        this.mediaDevices.add(new IOHolder(false, mediaDevice, solver));
        this.tryIO();
    }

    private void checkDisconnectPrevious(MediaDevice mediaDevice) {
        if (null != this.current && !this.current.id().equals(mediaDevice.id())) {
            Log.d(TAG, "ConnectSchedumer // checkDisconnectPrevious: push disconnecting current " + this.current.id());
            this.mediaDevices.add(new IOHolder(false, this.current.mediaDevice, null));
        }
    }

    private void tryIO() {
        if (!this.locked && this.mediaDevices.size() > 0) {
            this.locked = true;
            IOHolder holder = this.mediaDevices.get(0);
            this.mediaDevices.remove(0);
            Log.d(TAG, "STARTING --> " + holder.mediaDevice.id());
            Promise<Boolean> promise = holder.connect ? this.connectionWrapper.connect(holder.mediaDevice) : this.connectionWrapper.disconnect(holder.mediaDevice);
            Solver<Boolean> solver = holder.solver;
            if (holder.connect) {
                this.current = holder;
            } else if (null != this.current && holder.id().equals(this.current.id())) {
                this.current = null;
            }
            promise.then(result -> {
                if (solver != null) {
                    solver.resolve(result);
                }
                Log.d(TAG, "done for " + holder.mediaDevice.id() + " " + (Object)((Object)holder.mediaDevice.connectionState()));
                this.locked = false;
                this.tryIO();
            }).error(error -> {
                if (solver != null) {
                    solver.reject(error);
                }
                error.printStackTrace();
                Log.d(TAG, "done for " + holder.mediaDevice.id() + " " + (Object)((Object)holder.mediaDevice.connectionState()));
                this.locked = false;
                this.tryIO();
            });
        } else if (!this.locked) {
            this.flushWaitFors();
        }
    }

    private void flushWaitFors() {
        for (Solver<ConnectScheduler> solver : this.waitFors) {
            try {
                solver.resolve((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.waitFors.clear();
    }

    @Nullable
    public MediaDevice current() {
        IOHolder holder = this.current;
        return null != holder ? holder.mediaDevice : null;
    }

    public Promise<ConnectScheduler> waitFor() {
        if (!this.locked) {
            return Promise.resolve((Object)this);
        }
        return new Promise(solver -> this.waitFors.add((Solver<ConnectScheduler>)solver));
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void cancelAwaitingConnect() {
        int index = 0;
        while (index < this.mediaDevices.size()) {
            IOHolder holder = this.mediaDevices.get(index);
            if (holder.connect && null != holder.solver) {
                Promise.reject(holder.solver, (Throwable)new CancellationException("canceled"));
                this.mediaDevices.remove(index);
                continue;
            }
            ++index;
        }
    }

    private class IOHolder {
        public boolean connect;
        @NonNull
        public MediaDevice mediaDevice;
        @Nullable
        public Solver<Boolean> solver;

        public IOHolder(@NonNull boolean connect, @Nullable MediaDevice mediaDevice, Solver<Boolean> solver) {
            this.connect = connect;
            this.mediaDevice = mediaDevice;
            this.solver = solver;
        }

        @NonNull
        public String id() {
            return this.mediaDevice.id();
        }
    }
}

