/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.manager;

import android.bluetooth.BluetoothHeadset;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio.utils.__Call;
import com.voxeet.audio.utils.__Opt;
import com.voxeet.audio2.AudioDeviceManager;
import com.voxeet.audio2.devices.BluetoothDevice;
import com.voxeet.audio2.devices.BluetoothDeviceConnectionWrapper;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.PlatformDeviceConnectionWrapper;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.audio2.manager.IDeviceManager;
import com.voxeet.audio2.manager.bluetooth.BluetoothAction;
import com.voxeet.audio2.manager.bluetooth.BluetoothDeviceReceiver;
import com.voxeet.audio2.manager.bluetooth.BluetoothHeadsetServiceListener;
import com.voxeet.audio2.system.SystemAudioManager;
import com.voxeet.promise.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BluetoothHeadsetDeviceManager
implements IDeviceManager<BluetoothDevice> {
    private static final String TAG = BluetoothHeadsetDeviceManager.class.getSimpleName();
    private final __Call<List<BluetoothDevice>> connectivityUpdate;
    private final IMediaDeviceConnectionState connectionState;
    private final BluetoothDeviceReceiver bluetoothDeviceReceiver;
    private final Context context;
    private BluetoothDevice active;
    private Runnable runnable;
    private Handler handler;
    private final AudioDeviceManager audioDeviceManager;
    private SystemAudioManager systemAudioManager;
    private BluetoothHeadsetServiceListener bluetoothHeadsetServiceListener;
    private ArrayList<BluetoothDevice> list;
    private HashMap<String, PlatformDeviceConnectionWrapper> wrappers = new HashMap();
    private HashMap<String, BluetoothDeviceConnectionWrapper> waitingConnectivity = new HashMap();
    private boolean sco_connected = false;

    public BluetoothHeadsetDeviceManager(@NonNull Context context, @NonNull AudioDeviceManager audioDeviceManager, @NonNull SystemAudioManager systemAudioManager, @NonNull __Call<List<BluetoothDevice>> connectivityUpdate, @NonNull IMediaDeviceConnectionState connectionState) {
        this.context = context;
        this.audioDeviceManager = audioDeviceManager;
        this.systemAudioManager = systemAudioManager;
        this.connectivityUpdate = connectivityUpdate;
        this.connectionState = connectionState;
        this.list = new ArrayList();
        this.bluetoothHeadsetServiceListener = new BluetoothHeadsetServiceListener(this::onNewBluetoothServiceConnectivity);
        this.bluetoothDeviceReceiver = new BluetoothDeviceReceiver(this::onNewBluetoothDeviceState);
        this.bluetoothHeadsetServiceListener.connect(context);
        this.bluetoothDeviceReceiver.connect(context);
        this.handler = null;
        this.runnable = () -> {
            try {
                RequestDevices requestDevices = this.requestDevices();
                if (requestDevices.hasNew) {
                    connectivityUpdate.apply(requestDevices.list);
                }
            }
            catch (Exception exception) {
                Log.e(TAG, "Exception in handler", exception);
            }
            android.bluetooth.BluetoothDevice device = this.bluetoothHeadsetServiceListener.getActiveDevice();
            this.updateActiveDevice(device);
            if (null != this.handler) {
                this.handler.postDelayed(this.runnable, 5000L);
            }
        };
    }

    public boolean canFetchAndSetActiveDevices() {
        return this.bluetoothHeadsetServiceListener.canFetchAndSetActiveDevices();
    }

    public boolean isConnected() {
        return false;
    }

    @Override
    @NonNull
    public Promise<List<MediaDevice>> enumerateDevices() {
        return new Promise(solver -> solver.resolve(new ArrayList<BluetoothDevice>(this.devices())));
    }

    @Override
    @NonNull
    public Promise<List<BluetoothDevice>> enumerateTypedDevices() {
        return new Promise(solver -> solver.resolve(this.devices()));
    }

    @Override
    public boolean isWorking() {
        return this.bluetoothHeadsetServiceListener.isConnected();
    }

    public BluetoothDevice active() {
        return this.active;
    }

    private void onNewBluetoothServiceConnectivity(@NonNull BluetoothHeadsetServiceListener listener) {
        Log.d(TAG, "onNewBluetoothServiceConnectivity :: " + listener.isConnected());
        this.connectivityUpdate.apply(this.devices());
        if (listener.isConnected()) {
            this.handler = new Handler(Looper.getMainLooper());
            this.handler.post(this.runnable);
        } else {
            this.handler.removeCallbacks(this.runnable);
            this.handler = null;
        }
    }

    private void onNewBluetoothDeviceState(@NonNull BluetoothAction bluetoothAction) {
        Log.d(TAG, "onNewBluetoothDeviceState " + bluetoothAction);
        BluetoothDevice device = this.matching(this.list, bluetoothAction.device);
        BluetoothDeviceConnectionWrapper waitingCall = __Opt.of(device).then(d -> this.waitingConnectivity.get(d.id())).orNull();
        if (BluetoothAction.Action.DEVICE_DISCONNECTED.equals((Object)bluetoothAction.action)) {
            Log.d(TAG, "the device is being disconnected...");
            Log.d(TAG, "exists ? " + device);
            if (null != device) {
                switch (__Opt.of(device.connectionState()).or(ConnectionState.DISCONNECTED)) {
                    case CONNECTED: 
                    case CONNECTING: {
                        Log.d(TAG, "oops... we need to stop this !");
                        break;
                    }
                    default: {
                        Log.d(TAG, "state is already shutting down...");
                        break;
                    }
                }
            } else {
                Log.d(TAG, "the corresponding device in list does not exists");
            }
        }
        Set<Map.Entry<String, BluetoothDeviceConnectionWrapper>> set = this.waitingConnectivity.entrySet();
        switch (bluetoothAction.action) {
            case SCO_AUDIO_CONNECTED: {
                this.sco_connected = true;
                for (Map.Entry<String, BluetoothDeviceConnectionWrapper> entry : set) {
                    Log.d(TAG, "having awaiting sco on... resolving");
                    if (!entry.getValue().connect) {
                        Promise.reject(entry.getValue().solver, (Throwable)new IllegalStateException("oops"));
                        continue;
                    }
                    entry.getValue().solver.resolve((Object)true);
                }
                this.waitingConnectivity.clear();
                break;
            }
            case SCO_AUDIO_DISCONNECTED: {
                this.sco_connected = false;
                for (Map.Entry<String, BluetoothDeviceConnectionWrapper> entry : set) {
                    Log.d(TAG, "having awaiting sco off... resolving");
                    if (entry.getValue().connect) {
                        Promise.reject(entry.getValue().solver, (Throwable)new IllegalStateException("oops"));
                        continue;
                    }
                    entry.getValue().solver.resolve((Object)true);
                }
                this.waitingConnectivity.clear();
            }
        }
        String id = __Opt.of(bluetoothAction.device).then(android.bluetooth.BluetoothDevice::getAddress).or("");
        PlatformDeviceConnectionWrapper wrapper = this.wrappers.get(id);
        Log.d(TAG, "firing up to " + wrapper + " the event " + (Object)((Object)bluetoothAction.action));
        if (null != wrapper) {
            switch (bluetoothAction.action) {
                case DEVICE_ACTIVE_CHANGED: {
                    if (this.active != null && device == null) {
                        Log.d(TAG, "switch to disconnected device ... disconnect");
                        this.audioDeviceManager.disconnect(this.active).then(done -> Log.d(TAG, "disconnect done for this device")).error(Throwable::printStackTrace);
                    }
                    this.active = device;
                    break;
                }
                case DEVICE_CONNECTED: {
                    wrapper.setPlatformConnectionState(ConnectionState.CONNECTED);
                    break;
                }
                case DEVICE_DISCONNECTED: {
                    wrapper.setPlatformConnectionState(ConnectionState.DISCONNECTED);
                    if (null == device) break;
                    this.audioDeviceManager.current().then(mediaDevice -> {
                        if (null == mediaDevice) {
                            return Promise.resolve((Object)true);
                        }
                        if (mediaDevice.id().equals(device.id())) {
                            return this.audioDeviceManager.disconnect(device);
                        }
                        return Promise.resolve((Object)true);
                    }).then(result -> Log.d(TAG, "disconnecting the connect device because it was the main one")).error(Throwable::printStackTrace);
                    break;
                }
            }
        }
        this.connectivityUpdate.apply(this.devices());
    }

    private List<BluetoothDevice> devices() {
        return this.requestDevices().list;
    }

    private RequestDevices requestDevices() {
        boolean hasNew = false;
        BluetoothHeadset headset = this.bluetoothHeadsetServiceListener.bluetoothHeadset();
        List devices = __Opt.of(headset).then(BluetoothHeadset::getConnectedDevices).or(new ArrayList());
        for (android.bluetooth.BluetoothDevice device : devices) {
            BluetoothDevice in_list = this.matching(this.list, device);
            if (null != in_list) {
                in_list.update(device);
                continue;
            }
            hasNew = true;
            in_list = new BluetoothDevice(this.systemAudioManager.audioManager(), this.connectionState, DeviceType.BLUETOOTH, this, device, wrapper -> this.wrappers.put(device.getAddress(), (PlatformDeviceConnectionWrapper)wrapper), wrapper -> this.waitingConnectivity.put(device.getAddress(), (BluetoothDeviceConnectionWrapper)wrapper), this::setActiveDevice, this::onDisconnected);
            this.list.add(in_list);
        }
        return new RequestDevices(hasNew, this.list);
    }

    private void onDisconnected(@NonNull BluetoothDevice bluetoothDevice) {
    }

    private void setActiveDevice(@NonNull BluetoothDevice device) {
        if (null != this.bluetoothHeadsetServiceListener) {
            Log.d(TAG, "setActive device to " + device);
            this.bluetoothHeadsetServiceListener.setActiveDevice(device.bluetoothDevice());
        }
    }

    @Nullable
    private BluetoothDevice matching(List<BluetoothDevice> list, @Nullable android.bluetooth.BluetoothDevice device) {
        if (null == device) {
            return null;
        }
        for (BluetoothDevice in_list : list) {
            if (!__Opt.of(in_list.id()).or("").equals(device.getAddress())) continue;
            return in_list;
        }
        return null;
    }

    public boolean isSCOOn() {
        return this.sco_connected;
    }

    private void updateActiveDevice(@Nullable android.bluetooth.BluetoothDevice device) {
        this.active = null != device ? this.matching(this.list, device) : null;
    }

    private class RequestDevices {
        public boolean hasNew = false;
        public List<BluetoothDevice> list;

        public RequestDevices(boolean hasNew, List<BluetoothDevice> list) {
            this.hasNew = hasNew;
            this.list = list;
        }
    }
}

