/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.mode.BluetoothMode;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio.utils.__Call;
import com.voxeet.audio2.devices.BluetoothDeviceConnectionWrapper;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.PlatformDeviceConnectionWrapper;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.audio2.manager.BluetoothHeadsetDeviceManager;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;

public class BluetoothDevice
extends MediaDevice<android.bluetooth.BluetoothDevice> {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private final __Call<BluetoothDeviceConnectionWrapper> waitForSolver;
    private final __Call<BluetoothDevice> setActive;
    private final BluetoothHeadsetDeviceManager bluetoothHeadsetDeviceManager;
    private final __Call<BluetoothDevice> onDisconnected;
    @NonNull
    private AudioManager audioManager;
    private AudioFocusManager audioFocusManagerCall = new AudioFocusManager(AudioFocusMode.CALL);
    @NonNull
    private BluetoothMode mode;
    private Cancellable runnable;

    public BluetoothDevice(@NonNull AudioManager audioManager, @NonNull IMediaDeviceConnectionState connectionState, @NonNull DeviceType deviceType, @NonNull BluetoothHeadsetDeviceManager bluetoothHeadsetDeviceManager, @NonNull android.bluetooth.BluetoothDevice bluetoothDevice, @NonNull __Call<PlatformDeviceConnectionWrapper> wrapper, @NonNull __Call<BluetoothDeviceConnectionWrapper> waitForSolver, @NonNull __Call<BluetoothDevice> setActive, @NonNull __Call<BluetoothDevice> onDisconnected) {
        super(connectionState, deviceType, bluetoothDevice.getAddress(), bluetoothDevice);
        this.bluetoothHeadsetDeviceManager = bluetoothHeadsetDeviceManager;
        this.setActive = setActive;
        this.waitForSolver = waitForSolver;
        this.audioManager = audioManager;
        this.onDisconnected = onDisconnected;
        this.mode = new BluetoothMode(audioManager, this.audioFocusManagerCall);
        wrapper.apply(this::setPlatformConnectionState);
    }

    @Override
    @NonNull
    protected Promise<Boolean> connect() {
        return new Promise(solver -> {
            this.setActive.apply(this);
            this.setConnectionState(ConnectionState.CONNECTING);
            new Promise(second -> {
                this.postTimeout((Solver<Boolean>)second);
                Log.d(this.id(), "call for apply connect... sco:=" + this.bluetoothHeadsetDeviceManager.isSCOOn());
                this.waitForSolver.apply(new BluetoothDeviceConnectionWrapper((Solver<Boolean>)second, true));
                this.mode.apply(false);
                this.audioManager.setBluetoothScoOn(true);
                this.audioManager.startBluetoothSco();
            }).then(b -> {
                this.cancelRunnable();
                Log.d(this.id(), "connect done");
                this.setConnectionState(ConnectionState.CONNECTED);
                solver.resolve((Object)true);
            }).error(err -> {
                this.cancelRunnable();
                Log.d(this.id(), "connect done with error");
                this.setConnectionState(ConnectionState.CONNECTED);
                solver.resolve((Object)true);
            });
        });
    }

    @Override
    @NonNull
    protected Promise<Boolean> disconnect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.DISCONNECTING);
            new Promise(second -> {
                this.postTimeout((Solver<Boolean>)second);
                if (!ConnectionState.DISCONNECTED.equals((Object)this.platformConnectionState)) {
                    Log.d(this.id(), "call for apply disconnect... sco:=" + this.bluetoothHeadsetDeviceManager.isSCOOn());
                    if (this.bluetoothHeadsetDeviceManager.isSCOOn()) {
                        this.waitForSolver.apply(new BluetoothDeviceConnectionWrapper((Solver<Boolean>)second, false));
                        this.audioManager.setBluetoothScoOn(false);
                        this.audioManager.stopBluetoothSco();
                    } else {
                        second.resolve((Object)true);
                    }
                } else {
                    second.resolve((Object)true);
                }
            }).then(b -> {
                this.cancelRunnable();
                Log.d(this.id(), "disconnect done");
                this.mode.abandonAudioFocus();
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)true);
                this.onDisconnected.apply(this);
            }).error(err -> {
                this.cancelRunnable();
                Log.d(this.id(), "disconnect done with error");
                this.mode.abandonAudioFocus();
                this.setConnectionState(ConnectionState.DISCONNECTED);
                solver.resolve((Object)true);
            });
        });
    }

    private void cancelRunnable() {
        if (null != this.runnable) {
            this.runnable.cancel = true;
            handler.removeCallbacks((Runnable)this.runnable);
            this.runnable = null;
        }
    }

    private void postTimeout(Solver<Boolean> second) {
        this.runnable = new Cancellable(() -> {
            Log.d(this.id(), "oops.... timedout /o\\");
            second.resolve((Object)false);
        });
        handler.postDelayed((Runnable)this.runnable, 5000L);
    }

    public boolean isConnected() {
        return this.mode.isConnected();
    }

    public void update(@NonNull android.bluetooth.BluetoothDevice device) {
        this.holder = device;
    }

    public android.bluetooth.BluetoothDevice bluetoothDevice() {
        return (android.bluetooth.BluetoothDevice)this.holder;
    }

    private class Cancellable
    implements Runnable {
        public boolean cancel = false;
        private Runnable run;

        public Cancellable(Runnable run) {
            this.run = run;
        }

        @Override
        public void run() {
            if (!this.cancel) {
                this.run.run();
            }
        }
    }
}

