/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.mode;

import android.media.AudioManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.voxeet.audio.MediaDevice;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.mode.AbstractMode;

public class SpeakerMode
extends AbstractMode {
    public SpeakerMode(@NonNull AudioManager manager, @NonNull AudioFocusManager audioFocusManager) {
        super(manager, audioFocusManager, MediaDevice.ROUTE_SPEAKER);
    }

    @Override
    public void apply(boolean speaker_state) {
        if ("samsung".equalsIgnoreCase(Build.BRAND)) {
            this.applySamsung(speaker_state);
        } else {
            this.applyNonSamsung(speaker_state);
        }
    }

    @Override
    public void requestAudioFocus() {
        this.forceVolumeControlStream(this.requestFocus);
        this.audioFocusManger.requestAudioFocus(this.manager, this.requestFocus);
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    void applyNonSamsung(boolean speaker_state) {
        this.manager.setMode(3);
        this.manager.setSpeakerphoneOn(speaker_state);
        this.requestAudioFocus();
    }

    void applySamsung(boolean speaker_state) {
        if (speaker_state) {
            this.manager.setSpeakerphoneOn(true);
            this.manager.setMode(-1);
        } else {
            this.manager.setSpeakerphoneOn(speaker_state);
            this.manager.setMode(3);
        }
        this.requestAudioFocus();
    }
}

