/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.devices;

import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.mode.MediaMode;
import com.voxeet.audio.mode.NormalMode;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.MediaDeviceHelper;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.promise.Promise;

public class NormalDevice
extends MediaDevice<DeviceType> {
    @NonNull
    private AudioManager audioManager;
    private AudioFocusManager audioFocusManagerCall = new AudioFocusManager(AudioFocusMode.CALL);
    private AudioFocusManager audioMediaFocusManagerCall = new AudioFocusManager(AudioFocusMode.MEDIA);
    @NonNull
    private NormalMode normalMode;
    private MediaMode mediaMode;

    public NormalDevice(@NonNull AudioManager audioManager, @NonNull IMediaDeviceConnectionState connectionState, @NonNull DeviceType deviceType, @NonNull String id) {
        super(connectionState, deviceType, id);
        this.audioManager = audioManager;
        this.normalMode = new NormalMode(audioManager, this.audioFocusManagerCall);
        this.mediaMode = new MediaMode(audioManager, this.audioMediaFocusManagerCall);
    }

    @Override
    @NonNull
    protected Promise<Boolean> connect() {
        return new Promise(solver -> {
            this.setConnectionState(ConnectionState.CONNECTING);
            this.normalMode.apply(false);
            this.setConnectionState(ConnectionState.CONNECTED);
            solver.resolve((Object)true);
        });
    }

    @Override
    @NonNull
    protected Promise<Boolean> disconnect() {
        return new Promise(solver -> {
            if (ConnectionState.DISCONNECTED.equals((Object)this.connectionState)) {
                solver.resolve((Object)true);
                return;
            }
            this.setConnectionState(ConnectionState.DISCONNECTING);
            this.normalMode.abandonAudioFocus();
            this.mediaMode.apply(false);
            this.setConnectionState(ConnectionState.DISCONNECTED);
            solver.resolve((Object)true);
        });
    }

    @Override
    @NonNull
    public DeviceType deviceType() {
        if (MediaDeviceHelper.isWiredHeadsetConnected(this.audioManager) && ConnectionState.CONNECTED.equals((Object)this.connectionState)) {
            return DeviceType.WIRED_HEADSET;
        }
        return super.deviceType();
    }
}

