/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.manager;

import android.support.annotation.NonNull;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.NormalDevice;
import com.voxeet.audio2.devices.NormalMediaDevice;
import com.voxeet.audio2.devices.SpeakerDevice;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.audio2.devices.description.IMediaDeviceConnectionState;
import com.voxeet.audio2.manager.IDeviceManager;
import com.voxeet.audio2.system.SystemAudioManager;
import com.voxeet.promise.Promise;
import java.util.ArrayList;
import java.util.List;

public class SystemDeviceManager
implements IDeviceManager<MediaDevice> {
    private final SpeakerDevice speakerDevice;
    private final NormalDevice normalDevice;
    private final NormalMediaDevice normalMediaDevice;
    private SystemAudioManager systemAudioManager;
    private ArrayList<MediaDevice> list;

    public SystemDeviceManager(@NonNull SystemAudioManager systemAudioManager, @NonNull IMediaDeviceConnectionState connectionState) {
        this.systemAudioManager = systemAudioManager;
        this.speakerDevice = new SpeakerDevice(systemAudioManager.audioManager(), connectionState, DeviceType.EXTERNAL_SPEAKER, "external_speaker");
        this.normalDevice = new NormalDevice(systemAudioManager.audioManager(), connectionState, DeviceType.INTERNAL_SPEAKER, "internal_speaker");
        this.normalMediaDevice = new NormalMediaDevice(systemAudioManager.audioManager(), connectionState, DeviceType.NORMAL_MEDIA, "normal_media");
        this.list = new ArrayList();
        this.list.add(this.normalDevice);
        this.list.add(this.speakerDevice);
        this.list.add(this.normalMediaDevice);
    }

    @Override
    @NonNull
    public Promise<List<MediaDevice>> enumerateDevices() {
        return this.enumerateTypedDevices();
    }

    @Override
    @NonNull
    public Promise<List<MediaDevice>> enumerateTypedDevices() {
        return Promise.resolve(this.list);
    }

    @Override
    public boolean isWorking() {
        return true;
    }
}

