/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.focus;

import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.voxeet.audio.focus.AudioFocusManagerAsync;
import com.voxeet.audio.focus.AudioFocusMode;
import com.voxeet.audio.focus.AudioFocusRequest;
import com.voxeet.audio.utils.Log;

@RequiresApi(api=26)
public class AudioFocusRequest26
implements AudioFocusRequest {
    private final AudioAttributes playbackAttributes;
    private static Handler sHandler = new Handler();
    private final AudioManager.OnAudioFocusChangeListener focusRequest;
    private final android.media.AudioFocusRequest focusRequestBuilt;
    private final AudioFocusMode mode;

    @RequiresApi(value=26)
    public AudioFocusRequest26(AudioFocusMode mode) {
        int usage = 2;
        int content = 1;
        this.mode = mode;
        switch (mode) {
            case MEDIA: {
                usage = 1;
                content = 2;
                break;
            }
        }
        this.playbackAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(content).build();
        this.focusRequest = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                Log.d("AudioFocusRequest", "onAudioFocusChange: " + focusChange);
            }
        };
        this.focusRequestBuilt = new AudioFocusRequest.Builder(1).setAudioAttributes(this.playbackAttributes).setAcceptsDelayedFocusGain(true).setWillPauseWhenDucked(true).setOnAudioFocusChangeListener(this.focusRequest, sHandler).build();
    }

    @Override
    @RequiresApi(api=26)
    public int requestAudioFocus(@NonNull AudioManager manager, int audioFocusVolumeType) {
        AudioFocusManagerAsync.post(() -> manager.setMode(AudioFocusMode.CALL.equals((Object)this.mode) ? 3 : 0), () -> {});
        Log.d("AudioFocusRequest", "requestAudioFocus");
        manager.requestAudioFocus(null, audioFocusVolumeType, 1);
        return manager.requestAudioFocus(this.focusRequestBuilt);
    }

    @Override
    @RequiresApi(api=26)
    public int abandonAudioFocus(@NonNull AudioManager manager) {
        Log.d("AudioFocusRequest", "abandonAudioFocus");
        return manager.abandonAudioFocusRequest(this.focusRequestBuilt);
    }
}

