/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio2.manager.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio.utils.__Call;
import com.voxeet.audio2.manager.bluetooth.BluetoothAction;

public class BluetoothDeviceReceiver {
    private static final String TAG = BluetoothDeviceReceiver.class.getSimpleName();
    private static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED";
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (null == action) {
                action = "";
            }
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            Log.d(TAG, "onReceive: with device ? " + device);
            if (null != device) {
                Log.d(TAG, "device := " + device.getAddress() + " " + device.getName());
            }
            block6 : switch (action) {
                case "android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED": {
                    Log.d(TAG, "onReceive: acl connected");
                    BluetoothDeviceReceiver.this.callback.apply(new BluetoothAction(BluetoothAction.Action.DEVICE_ACTIVE_CHANGED, device));
                    break;
                }
                case "android.bluetooth.device.action.ACL_CONNECTED": {
                    Log.d(TAG, "onReceive: acl connected");
                    BluetoothDeviceReceiver.this.callback.apply(new BluetoothAction(BluetoothAction.Action.DEVICE_CONNECTED, device));
                    break;
                }
                case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                    Log.d(TAG, "onReceive: acl disconnected");
                    BluetoothDeviceReceiver.this.callback.apply(new BluetoothAction(BluetoothAction.Action.DEVICE_DISCONNECTED, device));
                    break;
                }
                case "android.media.ACTION_SCO_AUDIO_STATE_UPDATED": {
                    Log.d(TAG, "onReceive: sco audio state changed");
                    int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                    switch (state) {
                        case 1: {
                            Log.d(TAG, "onReceive: sco audio state connected");
                            BluetoothDeviceReceiver.this.callback.apply(new BluetoothAction(BluetoothAction.Action.SCO_AUDIO_CONNECTED, device));
                            break block6;
                        }
                        case 0: {
                            Log.d(TAG, "onReceive: sco audio state disconnected");
                            BluetoothDeviceReceiver.this.callback.apply(new BluetoothAction(BluetoothAction.Action.SCO_AUDIO_DISCONNECTED, device));
                            break block6;
                        }
                        case 2: {
                            Log.d(TAG, "onReceive: sco audio state connecting");
                            BluetoothDeviceReceiver.this.callback.apply(new BluetoothAction(BluetoothAction.Action.SCO_AUDIO_CONNECTING, device));
                        }
                    }
                }
            }
        }
    };
    private final __Call<BluetoothAction> callback;

    public void connect(@NonNull Context context) {
        context.registerReceiver(this.receiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        context.registerReceiver(this.receiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        Intent scoIntent = context.registerReceiver(this.receiver, new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"));
        context.registerReceiver(this.receiver, new IntentFilter(ACTION_ACTIVE_DEVICE_CHANGED));
        if (null != scoIntent) {
            this.receiver.onReceive(context, scoIntent);
        }
    }

    public BluetoothDeviceReceiver(@NonNull __Call<BluetoothAction> callback) {
        this.callback = callback;
    }
}

