/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.receiver;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.voxeet.audio.machines.BluetoothHeadsetMachine;
import com.voxeet.audio.machines.WiredHeadsetMachine;
import com.voxeet.audio.machines.WiredInformation;
import com.voxeet.audio.mode.BluetoothMode;
import com.voxeet.audio.utils.Log;

public class HeadsetStateReceiver
extends BroadcastReceiver {
    private static final String TAG = HeadsetStateReceiver.class.getSimpleName();
    private WiredHeadsetMachine wiredHeadsetMachine;
    private BluetoothHeadsetMachine bluetoothHeadsetMachine;
    private BluetoothMode bluetoothMode;
    private boolean enabled = true;

    private HeadsetStateReceiver() {
    }

    public HeadsetStateReceiver(@NonNull WiredHeadsetMachine wiredHeadsetMachine, @NonNull BluetoothHeadsetMachine bluetoothHeadsetMachine, @NonNull BluetoothMode bluetoothMode) {
        this();
        this.wiredHeadsetMachine = wiredHeadsetMachine;
        this.bluetoothHeadsetMachine = bluetoothHeadsetMachine;
        this.bluetoothMode = bluetoothMode;
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void onReceive(Context context, Intent intent) {
        if (!this.enabled) {
            Log.d(TAG, "onReceive: unable to comply, the onReceive is receive while being disabled");
            return;
        }
        Log.d(TAG, "onReceive: complying, the onReceive event is received while being activated");
        String action = intent.getAction();
        if (null == action) {
            action = "";
        }
        block6 : switch (action) {
            case "android.intent.action.HEADSET_PLUG": {
                Log.d(TAG, "onReceive: headset plug");
                int state = intent.getIntExtra("state", -1);
                int has_mic = intent.getIntExtra("microphone", -1);
                WiredInformation information = new WiredInformation(has_mic > 0, state);
                this.wiredHeadsetMachine.connect(information);
                break;
            }
            case "android.bluetooth.device.action.ACL_CONNECTED": {
                Log.d(TAG, "onReceive: acl connected");
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                this.bluetoothHeadsetMachine.connect(device);
                break;
            }
            case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                Log.d(TAG, "onReceive: acl disconnected");
                this.bluetoothHeadsetMachine.disconnect();
                break;
            }
            case "android.media.SCO_AUDIO_STATE_CHANGED": {
                Log.d(TAG, "onReceive: sco audio state changed");
                int l_state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                switch (l_state) {
                    case 1: {
                        Log.d(TAG, "onReceive: sco audio state connected");
                        this.bluetoothMode.requestAudioFocus();
                        break block6;
                    }
                    case 0: {
                        Log.d(TAG, "onReceive: sco audio state disconnected");
                        this.bluetoothMode.abandonAudioFocus();
                    }
                }
            }
        }
    }
}

