/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.mode;

import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.utils.Invoke;

public abstract class AbstractMode {
    protected AudioFocusManager audioFocusManger;
    protected AudioManager manager;
    private AudioRoute audioRoute;
    protected int requestFocus = 0;
    private int abandonFocus = 3;

    private AbstractMode() {
    }

    public AbstractMode(@NonNull AudioManager manager, @NonNull AudioFocusManager audioFocusManager, @NonNull AudioRoute audioRoute) {
        this();
        this.manager = manager;
        this.audioFocusManger = audioFocusManager;
        this.audioRoute = audioRoute;
    }

    public abstract void apply(boolean var1);

    public abstract void requestAudioFocus();

    public abstract boolean isConnected();

    public void abandonAudioFocus() {
        this.manager.setMode(0);
        this.audioFocusManger.abandonAudioFocus(this.manager);
        this.forceVolumeControlStream(this.abandonFocus);
    }

    protected void forceVolumeControlStream(int volumeMode) {
        Invoke.callVoidIntArg(this.manager, "forceVolumeControlStream", volumeMode);
    }

    public final AudioRoute getAudioRoute() {
        return this.audioRoute;
    }

    public void configureVolumeStream(int requestFocus, int abandonFocus) {
        this.requestFocus = requestFocus;
        this.abandonFocus = abandonFocus;
    }
}

