/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Window;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.listeners.IAudioRouteListener;
import com.voxeet.audio.listeners.IMediaStateListener;
import com.voxeet.audio.listeners.ListenerHolder;
import com.voxeet.audio.machines.BluetoothHeadsetMachine;
import com.voxeet.audio.machines.WiredHeadsetMachine;
import com.voxeet.audio.mode.AbstractMode;
import com.voxeet.audio.mode.BluetoothMode;
import com.voxeet.audio.mode.MediaMode;
import com.voxeet.audio.mode.NormalMode;
import com.voxeet.audio.mode.SpeakerMode;
import com.voxeet.audio.mode.WiredMode;
import com.voxeet.audio.receiver.HeadsetStateReceiver;
import com.voxeet.audio.utils.Invoke;
import com.voxeet.audio.utils.Log;
import java.util.ArrayList;
import java.util.List;

public class AudioStackManager {
    private static final String TAG = AudioStackManager.class.getSimpleName();
    private WiredHeadsetMachine mWiredMachine;
    private BluetoothHeadsetMachine mBluetoothMachine;
    private Context mContext;
    private SpeakerMode speakerMode;
    private WiredMode wiredMode;
    private BluetoothMode bluetoothMode;
    private NormalMode normalMode;
    private MediaMode mediaMode;
    private AbstractMode currentMode;
    private AudioManager mServiceAudioManager;
    private HeadsetStateReceiver mHeadsetStateReceiver;
    private ListenerHolder<IMediaStateListener> mMediaStateListeners = new ListenerHolder();
    private ListenerHolder<IAudioRouteListener> mAudioRouteListeners = new ListenerHolder<IAudioRouteListener>(new ListenerHolder.Callback<IAudioRouteListener>(){

        @Override
        public void apply(IAudioRouteListener listener) {
            try {
                listener.onAudioRouteChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    });
    private AudioFocusManager audioFocusManager = new AudioFocusManager();
    private boolean enabled;

    public void notifyAudioRoute() {
        this.mAudioRouteListeners.notif();
    }

    public void disable() {
        this.mBluetoothMachine.enable(false);
        Log.d(TAG, "disable");
        this.enabled = false;
        this.mHeadsetStateReceiver.enable(this.enabled);
    }

    public void enable() {
        Log.d(TAG, "enable");
        this.enabled = true;
        this.mHeadsetStateReceiver.enable(this.enabled);
        this.checkOutputRoute();
    }

    private AudioStackManager() {
    }

    public AudioStackManager(Context context) {
        this();
        Log.d(TAG, "AudioStackManager: init");
        this.mContext = context;
        this.mServiceAudioManager = (AudioManager)context.getSystemService("audio");
        this.speakerMode = new SpeakerMode(this.mServiceAudioManager, this.audioFocusManager);
        this.wiredMode = new WiredMode(this.mServiceAudioManager, this.audioFocusManager);
        this.bluetoothMode = new BluetoothMode(this.mServiceAudioManager, this.audioFocusManager);
        this.normalMode = new NormalMode(this.mServiceAudioManager, this.audioFocusManager);
        this.mediaMode = new MediaMode(this.mServiceAudioManager, this.audioFocusManager);
        this.currentMode = this.normalMode;
        this.mBluetoothMachine = new BluetoothHeadsetMachine(context, this.mMediaStateListeners, this, this.mServiceAudioManager, this.bluetoothMode);
        this.mWiredMachine = new WiredHeadsetMachine(this.mMediaStateListeners, this, this.mServiceAudioManager, this.wiredMode);
        this.mHeadsetStateReceiver = new HeadsetStateReceiver(this.mWiredMachine, this.mBluetoothMachine, this.bluetoothMode);
        this.mWiredMachine.warmup();
        this.mBluetoothMachine.warmup();
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
    }

    public void stop() {
        Log.d(TAG, "stop: ");
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetStateReceiver);
        this.mBluetoothMachine.enable(false);
        this.mBluetoothMachine.stop();
    }

    @NonNull
    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetConnected()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    @NonNull
    public AudioRoute outputRoute() {
        Log.d(TAG, "outputRoute: ");
        return this.currentMode.getAudioRoute();
    }

    public boolean setOutputRoute(@NonNull AudioRoute route) {
        Log.d(TAG, "setOutputRoute: enabled ?" + this.enabled + " " + (Object)((Object)route));
        switch (route) {
            case ROUTE_SPEAKER: {
                if (this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected()) break;
                this.setSpeakerMode(true);
                this.notifyAudioRoute();
                return true;
            }
            case ROUTE_BLUETOOTH: 
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                if (this.isBluetoothHeadsetConnected()) {
                    this.mBluetoothMachine.enable(true);
                    break;
                }
                this.setSpeakerMode(false);
                break;
            }
        }
        this.notifyAudioRoute();
        return false;
    }

    public void setVolumeControlStream(Window window, int streamType) {
        try {
            window.setVolumeControlStream(streamType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSpeakerMode(final boolean speaker) {
        Log.d(TAG, "setSpeakerMode: enabled ?" + this.enabled + " " + speaker);
        if (this.isWiredHeadsetOn()) {
            Log.d(TAG, "setSpeakerMode: wired headset");
            this.wiredMode.apply(speaker);
        } else if (this.isBluetoothHeadsetConnected()) {
            Log.d(TAG, "setSpeakerMode: bluetooth");
            this.bluetoothMode.apply(speaker);
        } else {
            Log.d(TAG, "setSpeakerMode: standard");
            this.speakerMode.apply(speaker);
        }
        this.mMediaStateListeners.notif(new ListenerHolder.Callback<IMediaStateListener>(){

            @Override
            public void apply(IMediaStateListener listener) {
                listener.onSpeakerChanged(speaker);
            }
        });
        this.checkOutputRoute();
    }

    public void registerAudioRouteListener(@NonNull IAudioRouteListener listener) {
        this.mAudioRouteListeners.register(listener);
    }

    public void unregisterAudioRouteListener(@NonNull IAudioRouteListener listener) {
        this.mAudioRouteListeners.unregister(listener);
    }

    public void registerMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.register(listener);
    }

    public void unregisterMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.unregister(listener);
    }

    public int getDefaultSoundStreamType() {
        return 3;
    }

    public void resetDefaultSoundType() {
        this.forceVolumeControlStream(3);
    }

    public void forceVolumeControlStream(int type) {
        Invoke.callVoidIntArg(this.mServiceAudioManager, "forceVolumeControlStream", type);
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.mBluetoothMachine.isConnected();
    }

    public boolean isWiredHeadsetOn() {
        return this.wiredMode.isConnected();
    }

    public void setMediaRoute() {
        this.currentMode = this.mediaMode;
        this.checkOutputRoute();
    }

    public void unsetMediaRoute() {
        this.currentMode = this.normalMode;
        this.checkOutputRoute();
    }

    public void checkOutputRoute() {
        if (this.mediaMode == this.currentMode) {
            this.mediaMode.requestAudioFocus();
            android.util.Log.d((String)TAG, (String)"checkOutputRoute: mediaMode selected");
            return;
        }
        if (!this.enabled) {
            Log.d(TAG, "checkOutputRoute: unable to comply, is disabled");
            return;
        }
        Log.d(TAG, "checkOutputRoute in progress");
        if (this.isBluetoothHeadsetConnected()) {
            Log.d(TAG, "checkOutputRoute: bluetooth connected");
            this.bluetoothMode.requestAudioFocus();
            this.currentMode = this.bluetoothMode;
        } else if (this.isWiredHeadsetOn()) {
            Log.d(TAG, "checkOutputRoute: wired on");
            this.wiredMode.requestAudioFocus();
            this.currentMode = this.wiredMode;
        } else if (null != this.mServiceAudioManager && this.mServiceAudioManager.isSpeakerphoneOn()) {
            Log.d(TAG, "checkOutputRoute: speaker");
            this.speakerMode.requestAudioFocus();
            this.currentMode = this.speakerMode;
        } else {
            Log.d(TAG, "checkOutputRoute: normal mode");
            this.normalMode.requestAudioFocus();
            this.currentMode = this.normalMode;
        }
    }

    public AudioStackManager requestAudioFocus() {
        Log.d(TAG, "requestAudioFocus in progress " + this.currentMode);
        if (!this.enabled) {
            Log.d(TAG, "requestAudioFocus: unable to comply, is disabled");
            return this;
        }
        if (null != this.currentMode) {
            this.currentMode.requestAudioFocus();
        }
        return this;
    }

    public AudioStackManager abandonAudioFocus() {
        this.mBluetoothMachine.enable(false);
        if (null != this.currentMode) {
            this.currentMode.abandonAudioFocus();
        }
        return this;
    }

    public AudioStackManager configureVolumeStream(int requestFocus, int abandonFocus) {
        this.bluetoothMode.configureVolumeStream(requestFocus, abandonFocus);
        this.normalMode.configureVolumeStream(requestFocus, abandonFocus);
        this.speakerMode.configureVolumeStream(requestFocus, abandonFocus);
        this.wiredMode.configureVolumeStream(requestFocus, abandonFocus);
        return this;
    }

    @Nullable
    public Ringtone getSystemRingtone() {
        Uri uri = RingtoneManager.getDefaultUri((int)1);
        if (null == uri) {
            return null;
        }
        return RingtoneManager.getRingtone((Context)this.mContext, (Uri)uri);
    }

    private int getUiSoundsStreamType() {
        return Invoke.callReturnIntVoidArg(this.mServiceAudioManager, "getUiSoundsStreamType", 1);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

