/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.machines;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.audio.AudioStackManager;
import com.voxeet.audio.listeners.IMediaStateListener;
import com.voxeet.audio.listeners.ListenerHolder;
import com.voxeet.audio.machines.AbstractMachine;
import com.voxeet.audio.mode.AbstractMode;
import com.voxeet.audio.utils.Validate;

public class BluetoothHeadsetMachine
extends AbstractMachine<BluetoothDevice> {
    private static final String TAG = BluetoothHeadsetMachine.class.getSimpleName();
    private final Context mContext;
    private Handler handler = new Handler();
    private Runnable runnableBluetoothSco = new Runnable(){

        @Override
        public void run() {
            BluetoothHeadsetMachine.this.requestAudioFocus();
            try {
                BluetoothHeadsetMachine.this.manager.startBluetoothSco();
                BluetoothHeadsetMachine.this.manager.setBluetoothScoOn(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                BluetoothHeadsetMachine.this.isBluetoothScoStarted = false;
            }
        }
    };
    private final BluetoothAdapter mBluetoothAdapter;
    private BluetoothHeadsetListener mBluetoothHeadsetListener;
    private BluetoothHeadset mCurrentBluetoothHeadset;
    private boolean isBluetoothScoStarted;

    public BluetoothHeadsetMachine(Context context, ListenerHolder<IMediaStateListener> listener, AudioStackManager audioManager, AudioManager manager, AbstractMode audioMode) {
        super(listener, audioManager, manager, audioMode);
        this.mContext = context;
        this.mBluetoothHeadsetListener = new BluetoothHeadsetListener();
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter != null) {
            try {
                this.mBluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.mBluetoothHeadsetListener, 1);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void connect(BluetoothDevice connect) {
        this.updateBluetoothHeadsetConnectivity(connect);
    }

    @Override
    public void disconnect() {
        this.updateBluetoothHeadsetConnectivity(null);
    }

    @Override
    public void stop() {
        if (this.mCurrentBluetoothHeadset != null && this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mCurrentBluetoothHeadset);
        }
    }

    @Override
    public boolean isConnected() {
        this.checkForBluetoothDeviceAtStartUp();
        Log.d((String)TAG, (String)("isConnected: " + this.isBluetoothScoStarted));
        return this.isBluetoothScoStarted;
    }

    @Override
    public void warmup() {
        this.checkForBluetoothDeviceAtStartUp();
    }

    @Override
    public void enable(boolean isEnabled) {
        Log.d((String)TAG, (String)("enable: bluetooth " + isEnabled));
        this.audioManager.forceVolumeControlStream(3);
        this.audioManager.checkOutputRoute();
        try {
            if (isEnabled) {
                this.startBluetoothSco();
            } else {
                this.stopBluetoothSco();
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"No bluetooth headset connected");
        }
    }

    private void checkForBluetoothDeviceAtStartUp() {
        Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp");
        try {
            BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (mBluetoothAdapter != null && mBluetoothAdapter.isEnabled() && mBluetoothAdapter.getProfileConnectionState(1) == 2) {
                Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp: bluetooth connected");
                this.isBluetoothScoStarted = true;
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp: exception thrown, have you the BLUETOOTH permission?");
            e.printStackTrace();
        }
    }

    private void startBluetoothSco() {
        this.handler.postDelayed(this.runnableBluetoothSco, 3000L);
    }

    private void stopBluetoothSco() {
        this.handler.removeCallbacks(this.runnableBluetoothSco);
        if (this.isBluetoothScoStarted) {
            try {
                this.manager.setBluetoothScoOn(false);
                this.manager.stopBluetoothSco();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isBluetoothScoStarted = false;
        }
    }

    private void updateBluetoothHeadsetConnectivity(@Nullable BluetoothDevice device) {
        Log.d((String)TAG, (String)("updateBluetoothHeadsetConnectivity: " + device));
        if (null != this.mCurrentBluetoothHeadset) {
            if (Validate.hasBluetoothPermissions(this.mContext)) {
                this.isBluetoothScoStarted = this.mCurrentBluetoothHeadset.getConnectedDevices().size() > 0;
                this.isBluetoothScoStarted |= null != device;
            } else {
                Log.e((String)TAG, (String)"onServiceConnected: BLUETOOTH PERMISSION MISSING");
            }
            this.listenerHolder.notif(new ListenerHolder.Callback<IMediaStateListener>(){

                @Override
                public void apply(IMediaStateListener listener) {
                    listener.onBluetoothHeadsetStateChange(BluetoothHeadsetMachine.this.isBluetoothScoStarted);
                }
            });
            Log.d((String)TAG, (String)("onServiceConnected: isBluetoothScoStarted = " + this.isBluetoothScoStarted));
            this.startBluetoothSco();
            this.audioManager.checkOutputRoute();
            this.audioManager.notifyAudioRoute();
        }
    }

    private class BluetoothHeadsetListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothHeadsetListener() {
        }

        public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
            if (bluetoothProfile instanceof BluetoothHeadset) {
                BluetoothHeadsetMachine.this.mCurrentBluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            }
            BluetoothHeadsetMachine.this.updateBluetoothHeadsetConnectivity(null);
        }

        public void onServiceDisconnected(int i) {
            BluetoothHeadsetMachine.this.mCurrentBluetoothHeadset = null;
            BluetoothHeadsetMachine.this.isBluetoothScoStarted = false;
            Log.d((String)TAG, (String)"onServiceDisconnected: isBluetoothScoStarted = true");
            BluetoothHeadsetMachine.this.manager.stopBluetoothSco();
            BluetoothHeadsetMachine.this.listenerHolder.notif(new ListenerHolder.Callback<IMediaStateListener>(){

                @Override
                public void apply(IMediaStateListener listener) {
                    listener.onBluetoothHeadsetStateChange(false);
                }
            });
            BluetoothHeadsetMachine.this.audioManager.checkOutputRoute();
        }
    }
}

