/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Window;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.listeners.IAudioRouteListener;
import com.voxeet.audio.listeners.IMediaStateListener;
import com.voxeet.audio.listeners.ListenerHolder;
import com.voxeet.audio.machines.BluetoothHeadsetMachine;
import com.voxeet.audio.machines.WiredHeadsetMachine;
import com.voxeet.audio.machines.WiredInformation;
import com.voxeet.audio.mode.AbstractMode;
import com.voxeet.audio.mode.BluetoothMode;
import com.voxeet.audio.mode.NormalMode;
import com.voxeet.audio.mode.SpeakerMode;
import com.voxeet.audio.mode.WiredMode;
import com.voxeet.audio.utils.Invoke;
import java.util.ArrayList;
import java.util.List;

public class AudioStackManager {
    private static final String TAG = AudioStackManager.class.getSimpleName();
    private WiredHeadsetMachine mWiredMachine;
    private BluetoothHeadsetMachine mBluetoothMachine;
    private Context mContext;
    private SpeakerMode speakerMode;
    private WiredMode wiredMode;
    private BluetoothMode bluetoothMode;
    private NormalMode normalMode;
    private AbstractMode currentMode;
    private AudioManager mServiceAudioManager;
    private HeadsetStateReceiver mHeadsetStateReceiver;
    private ListenerHolder<IMediaStateListener> mMediaStateListeners = new ListenerHolder();
    private ListenerHolder<IAudioRouteListener> mAudioRouteListeners = new ListenerHolder<IAudioRouteListener>(new ListenerHolder.Callback<IAudioRouteListener>(){

        @Override
        public void apply(IAudioRouteListener listener) {
            try {
                listener.onAudioRouteChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    });
    private AudioFocusManager audioFocusManager = new AudioFocusManager();
    private boolean enabled;

    public void notifyAudioRoute() {
        this.mAudioRouteListeners.notif();
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    private AudioStackManager() {
        this.mHeadsetStateReceiver = new HeadsetStateReceiver();
    }

    public AudioStackManager(Context context) {
        this();
        this.mContext = context;
        this.mServiceAudioManager = (AudioManager)context.getSystemService("audio");
        this.speakerMode = new SpeakerMode(this.mServiceAudioManager, this.audioFocusManager);
        this.wiredMode = new WiredMode(this.mServiceAudioManager, this.audioFocusManager);
        this.bluetoothMode = new BluetoothMode(this.mServiceAudioManager, this.audioFocusManager);
        this.normalMode = new NormalMode(this.mServiceAudioManager, this.audioFocusManager);
        this.currentMode = this.normalMode;
        this.mBluetoothMachine = new BluetoothHeadsetMachine(context, this.mMediaStateListeners, this, this.mServiceAudioManager, this.bluetoothMode);
        this.mWiredMachine = new WiredHeadsetMachine(this.mMediaStateListeners, this, this.mServiceAudioManager, this.wiredMode);
        this.mWiredMachine.warmup();
        this.mBluetoothMachine.warmup();
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
    }

    public void stop() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetStateReceiver);
        this.mBluetoothMachine.enable(false);
        this.mBluetoothMachine.stop();
    }

    @NonNull
    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetConnected()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    @NonNull
    public AudioRoute outputRoute() {
        return this.currentMode.getAudioRoute();
    }

    public boolean setOutputRoute(@NonNull AudioRoute route) {
        switch (route) {
            case ROUTE_SPEAKER: {
                if (this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected()) break;
                this.setSpeakerMode(true);
                this.notifyAudioRoute();
                return true;
            }
            case ROUTE_BLUETOOTH: {
                if (!this.isBluetoothHeadsetConnected()) break;
                this.mBluetoothMachine.enable(true);
                break;
            }
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
        }
        this.notifyAudioRoute();
        return false;
    }

    public void setVolumeControlStream(Window window, int streamType) {
        try {
            window.setVolumeControlStream(streamType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSpeakerMode(final boolean speaker) {
        if (this.isWiredHeadsetOn()) {
            this.wiredMode.apply(speaker);
        } else if (this.isBluetoothHeadsetConnected()) {
            this.bluetoothMode.apply(speaker);
        } else {
            this.speakerMode.apply(speaker);
        }
        this.mMediaStateListeners.notif(new ListenerHolder.Callback<IMediaStateListener>(){

            @Override
            public void apply(IMediaStateListener listener) {
                listener.onSpeakerChanged(speaker);
            }
        });
        this.checkOutputRoute();
    }

    public void registerAudioRouteListener(@NonNull IAudioRouteListener listener) {
        this.mAudioRouteListeners.register(listener);
    }

    public void unregisterAudioRouteListener(@NonNull IAudioRouteListener listener) {
        this.mAudioRouteListeners.unregister(listener);
    }

    public void registerMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.register(listener);
    }

    public void unregisterMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.unregister(listener);
    }

    public int getDefaultSoundStreamType() {
        return 3;
    }

    public void resetDefaultSoundType() {
        this.forceVolumeControlStream(3);
    }

    public void forceVolumeControlStream(int type) {
        Invoke.callVoidIntArg(this.mServiceAudioManager, "forceVolumeControlStream", type);
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.mBluetoothMachine.isConnected();
    }

    public boolean isWiredHeadsetOn() {
        return this.wiredMode.isConnected();
    }

    public boolean isHeadphonesPlugged() {
        return this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected();
    }

    public void checkOutputRoute() {
        if (this.isBluetoothHeadsetConnected()) {
            this.bluetoothMode.requestAudioFocus();
            this.currentMode = this.bluetoothMode;
        } else if (this.isWiredHeadsetOn()) {
            this.wiredMode.requestAudioFocus();
            this.currentMode = this.wiredMode;
        } else if (null != this.mServiceAudioManager && this.mServiceAudioManager.isSpeakerphoneOn()) {
            this.speakerMode.requestAudioFocus();
            this.currentMode = this.speakerMode;
        } else {
            this.normalMode.requestAudioFocus();
            this.currentMode = this.normalMode;
        }
    }

    public AudioStackManager requestAudioFocus() {
        if (null != this.currentMode) {
            this.currentMode.requestAudioFocus();
        }
        return this;
    }

    public AudioStackManager abandonAudioFocus() {
        if (null != this.currentMode) {
            this.currentMode.abandonAudioFocus();
        }
        return this;
    }

    @Nullable
    public Ringtone getSystemRingtone() {
        Uri uri = RingtoneManager.getDefaultUri((int)1);
        if (null == uri) {
            return null;
        }
        return RingtoneManager.getRingtone((Context)this.mContext, (Uri)uri);
    }

    private int getUiSoundsStreamType() {
        return Invoke.callReturnIntVoidArg(this.mServiceAudioManager, "getUiSoundsStreamType", 1);
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)("onReceive: " + intent.getAction()));
            if (!AudioStackManager.this.enabled) {
                Log.d((String)TAG, (String)"onReceive: the AudioStackManager is disabled, nothing to do for action received");
                return;
            }
            String action = intent.getAction();
            if (null == action) {
                action = "";
            }
            block6 : switch (action) {
                case "android.intent.action.HEADSET_PLUG": {
                    int state = intent.getIntExtra("state", -1);
                    int has_mic = intent.getIntExtra("microphone", -1);
                    WiredInformation information = new WiredInformation(has_mic > 0, state);
                    AudioStackManager.this.mWiredMachine.connect(information);
                    break;
                }
                case "android.bluetooth.device.action.ACL_CONNECTED": {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    AudioStackManager.this.mBluetoothMachine.connect(device);
                    break;
                }
                case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                    AudioStackManager.this.mBluetoothMachine.disconnect();
                    break;
                }
                case "android.media.SCO_AUDIO_STATE_CHANGED": {
                    int l_state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                    Log.d((String)TAG, (String)"Audio SCO: android.media.SCO_AUDIO_STATE_CHANGED");
                    switch (l_state) {
                        case 1: {
                            AudioStackManager.this.bluetoothMode.requestAudioFocus();
                            break block6;
                        }
                        case 0: {
                            AudioStackManager.this.bluetoothMode.abandonAudioFocus();
                        }
                    }
                }
            }
        }
    }
}

