/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio.mode;

import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.mode.AbstractMode;

public class WiredMode
extends AbstractMode {
    public WiredMode(@NonNull AudioManager manager, @NonNull AudioFocusManager audioFocusManager) {
        super(manager, audioFocusManager, AudioRoute.ROUTE_HEADSET);
    }

    @Override
    public void apply(boolean speaker_state) {
        this.manager.setSpeakerphoneOn(false);
        this.manager.setMode(3);
        this.forceVolumeControlStream(0);
    }

    @Override
    public void requestAudioFocus() {
        this.forceVolumeControlStream(0);
        this.audioFocusManger.requestAudioFocus(this.manager);
    }

    @Override
    public boolean isConnected() {
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] audioDevices;
            for (AudioDeviceInfo deviceInfo : audioDevices = this.manager.getDevices(3)) {
                switch (deviceInfo.getType()) {
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
            }
        }
        return this.manager.isWiredHeadsetOn();
    }
}

