/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Window;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.focus.AudioFocusManager;
import com.voxeet.audio.listeners.IAudioRouteListener;
import com.voxeet.audio.listeners.IMediaStateListener;
import com.voxeet.audio.listeners.ListenerHolder;
import com.voxeet.audio.machines.BluetoothHeadsetMachine;
import com.voxeet.audio.machines.WiredHeadsetMachine;
import com.voxeet.audio.machines.WiredInformation;
import com.voxeet.audio.mode.BluetoothMode;
import com.voxeet.audio.mode.SpeakerMode;
import com.voxeet.audio.mode.WiredMode;
import com.voxeet.audio.utils.Invoke;
import java.util.ArrayList;
import java.util.List;

public class AudioManager {
    private static final String TAG = AudioManager.class.getSimpleName();
    private WiredHeadsetMachine mWiredMachine;
    private BluetoothHeadsetMachine mBluetoothMachine;
    private Context mContext;
    private SpeakerMode speakerMode;
    private WiredMode wiredMode;
    private BluetoothMode bluetoothMode;
    private android.media.AudioManager mServiceAudioManager;
    private HeadsetStateReceiver mHeadsetStateReceiver;
    private BluetoothAdapter mBluetoothAdapter;
    private AudioRoute mOutputRoute = AudioRoute.ROUTE_PHONE;
    private ListenerHolder<IMediaStateListener> mMediaStateListeners = new ListenerHolder();
    private ListenerHolder<IAudioRouteListener> mAudioRouteListeners = new ListenerHolder<IAudioRouteListener>(new ListenerHolder.Callback<IAudioRouteListener>(){

        @Override
        public void apply(IAudioRouteListener listener) {
            try {
                listener.onAudioRouteChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    });
    private AudioFocusManager manager = new AudioFocusManager();
    private boolean enabled;

    public void notifyAudioRoute() {
        this.mAudioRouteListeners.notif();
    }

    public void requestAudioFocus() {
        this.forceVolumeControlStream(0);
        this.manager.requestAudioFocus(this.mServiceAudioManager);
    }

    public void abandonAudioFocusRequest() {
        this.mServiceAudioManager.setMode(0);
        this.manager.abandonAudioFocus(this.mServiceAudioManager);
        this.forceVolumeControlStream(3);
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    private AudioManager() {
        this.mHeadsetStateReceiver = new HeadsetStateReceiver();
    }

    public AudioManager(Context context) {
        this();
        this.mContext = context;
        this.mServiceAudioManager = (android.media.AudioManager)context.getSystemService("audio");
        this.mBluetoothMachine = new BluetoothHeadsetMachine(context, this.mMediaStateListeners, this, this.mServiceAudioManager);
        this.mWiredMachine = new WiredHeadsetMachine(this.mMediaStateListeners, this, this.mServiceAudioManager);
        this.mWiredMachine.warmup();
        this.mBluetoothMachine.warmup();
        this.speakerMode = new SpeakerMode(this.mServiceAudioManager);
        this.wiredMode = new WiredMode(this.mServiceAudioManager);
        this.bluetoothMode = new BluetoothMode(this.mServiceAudioManager);
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
    }

    public void stop() {
        this.setBluetooth(false);
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetStateReceiver);
        this.mBluetoothMachine.stop();
    }

    @NonNull
    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetConnected()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    @NonNull
    public AudioRoute outputRoute() {
        return this.mOutputRoute;
    }

    public boolean setOutputRoute(@NonNull AudioRoute route) {
        switch (route) {
            case ROUTE_BLUETOOTH: {
                if (!this.isBluetoothHeadsetConnected()) break;
                this.setBluetooth(true);
                break;
            }
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
            case ROUTE_SPEAKER: {
                if (this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected()) {
                    return false;
                }
                this.setSpeakerMode(true);
                break;
            }
        }
        this.notifyAudioRoute();
        return true;
    }

    public void setVolumeControlStream(Window window, int streamType) {
        try {
            window.setVolumeControlStream(streamType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSpeakerMode(final boolean speaker) {
        Log.d((String)TAG, (String)("setSpeakerMode: " + this.isWiredHeadsetOn() + " " + this.isBluetoothHeadsetConnected()));
        if (this.isWiredHeadsetOn()) {
            this.wiredMode.apply(speaker);
            this.forceVolumeControlStream(0);
        } else if (this.isBluetoothHeadsetConnected()) {
            this.bluetoothMode.apply(speaker);
            this.forceVolumeControlStream(6);
        } else {
            this.speakerMode.apply(speaker);
            this.forceVolumeControlStream(0);
        }
        this.mMediaStateListeners.notif(new ListenerHolder.Callback<IMediaStateListener>(){

            @Override
            public void apply(IMediaStateListener listener) {
                listener.onSpeakerChanged(speaker);
            }
        });
        this.checkOutputRoute();
    }

    public void setBluetooth(boolean isEnabled) {
        this.mBluetoothMachine.enable(isEnabled);
    }

    public void registerAudioRouteListener(@NonNull IAudioRouteListener listener) {
        this.mAudioRouteListeners.register(listener);
    }

    public void unregisterAudioRouteListener(@NonNull IAudioRouteListener listener) {
        this.mAudioRouteListeners.unregister(listener);
    }

    public void registerMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.register(listener);
    }

    public void unregisterMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.unregister(listener);
    }

    public int getDefaultSoundStreamType() {
        return 3;
    }

    public void resetDefaultSoundType() {
        this.forceVolumeControlStream(3);
    }

    public void forceVolumeControlStream(int type) {
        Invoke.callVoidIntArg(this.mServiceAudioManager, "forceVolumeControlStream", type);
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.mBluetoothMachine.isConnected();
    }

    public boolean isWiredHeadsetOn() {
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] audioDevices;
            for (AudioDeviceInfo deviceInfo : audioDevices = this.mServiceAudioManager.getDevices(3)) {
                if (deviceInfo.getType() != 4 && deviceInfo.getType() != 3) continue;
                Log.d((String)TAG, (String)"isWiredHea-*dsetOn: headphone connected");
                return true;
            }
        }
        return this.mServiceAudioManager.isWiredHeadsetOn();
    }

    public boolean isHeadphonesPlugged() {
        return this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected();
    }

    public void checkOutputRoute() {
        this.mOutputRoute = this.isBluetoothHeadsetConnected() ? AudioRoute.ROUTE_BLUETOOTH : (this.isWiredHeadsetOn() ? AudioRoute.ROUTE_HEADSET : (null != this.mServiceAudioManager && this.mServiceAudioManager.isSpeakerphoneOn() ? AudioRoute.ROUTE_SPEAKER : AudioRoute.ROUTE_PHONE));
        this.requestAudioFocus();
    }

    private int getUiSoundsStreamType() {
        return Invoke.callReturnIntVoidArg(this.mServiceAudioManager, "getUiSoundsStreamType", 1);
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)("onReceive: " + intent.getAction()));
            if (!AudioManager.this.enabled) {
                Log.d((String)TAG, (String)"onReceive: the AudioManager is disabled, nothing to do for action received");
                return;
            }
            String action = intent.getAction();
            if (null == action) {
                action = "";
            }
            switch (action) {
                case "android.intent.action.HEADSET_PLUG": {
                    int state = intent.getIntExtra("state", -1);
                    int has_mic = intent.getIntExtra("microphone", -1);
                    WiredInformation information = new WiredInformation(has_mic > 0, state);
                    AudioManager.this.mWiredMachine.connect(information);
                    break;
                }
                case "android.bluetooth.device.action.ACL_CONNECTED": {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    AudioManager.this.mBluetoothMachine.connect(device);
                    break;
                }
                case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                    AudioManager.this.mBluetoothMachine.disconnect();
                    break;
                }
                case "android.media.SCO_AUDIO_STATE_CHANGED": {
                    int l_state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                    Log.d((String)TAG, (String)"Audio SCO: android.media.SCO_AUDIO_STATE_CHANGED");
                    switch (l_state) {
                        case 0: 
                        case 1: {
                            AudioManager.this.mBluetoothMachine.requestAudioFocus();
                        }
                    }
                }
            }
        }
    }
}

