/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.webrtc;

import android.support.annotation.Nullable;
import com.vonage.webrtc.LibvpxVp8Decoder;
import com.vonage.webrtc.LibvpxVp9Decoder;
import com.vonage.webrtc.VideoCodecInfo;
import com.vonage.webrtc.VideoDecoder;
import com.vonage.webrtc.VideoDecoderFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    @Override
    @Deprecated
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        return this.createDecoder(new VideoCodecInfo(codecType, new HashMap<String, String>()));
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (codecType.getName().equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("VP9") && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

