/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.Language;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public final class TranscriptionSettings
extends JsonableBaseObject {
    private Language language;
    private List<URI> eventUrl;
    private EventMethod eventMethod;
    private Boolean sentimentAnalysis;

    TranscriptionSettings() {
    }

    private TranscriptionSettings(Builder builder) {
        this.language = builder.language;
        this.eventMethod = builder.eventMethod;
        this.sentimentAnalysis = builder.sentimentAnalysis;
        if (builder.eventUrl != null) {
            this.eventUrl = Collections.singletonList(URI.create(builder.eventUrl));
        }
    }

    @JsonProperty(value="language")
    public Language getLanguage() {
        return this.language;
    }

    @JsonProperty(value="eventUrl")
    public List<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="sentimentAnalysis")
    public Boolean getSentimentAnalysis() {
        return this.sentimentAnalysis;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Language language;
        private String eventUrl;
        private EventMethod eventMethod;
        private Boolean sentimentAnalysis;

        private Builder() {
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder sentimentAnalysis(boolean sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        public TranscriptionSettings build() {
            return new TranscriptionSettings(this);
        }
    }
}

