/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.EventMethod;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class NotifyAction
extends JsonableBaseObject
implements Action {
    private Map<String, ?> payload;
    private Collection<URI> eventUrl;
    private EventMethod eventMethod;

    NotifyAction() {
    }

    private NotifyAction(Builder builder) {
        this.payload = builder.payload;
        this.eventUrl = builder.eventUrl != null ? Collections.singleton(URI.create(builder.eventUrl)) : null;
        this.eventMethod = builder.eventMethod;
    }

    @Override
    public String getAction() {
        return "notify";
    }

    @JsonProperty(value="payload")
    public Map<String, ?> getPayload() {
        return this.payload;
    }

    @JsonProperty(value="eventUrl")
    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public static Builder builder(Map<String, ?> payload, String eventUrl) {
        return NotifyAction.builder().payload(payload).eventUrl(eventUrl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, ?> payload;
        private String eventUrl;
        private EventMethod eventMethod;

        private Builder() {
        }

        public Builder payload(Map<String, ?> payload) {
            this.payload = payload;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public NotifyAction build() {
            return new NotifyAction(this);
        }
    }
}

