/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.video.ScreenLayoutType;
import java.util.Objects;

public final class StreamCompositionLayout
extends JsonableBaseObject {
    @JsonIgnore
    String id;
    private ScreenLayoutType type;
    private ScreenLayoutType screenshareType;
    private String stylesheet;

    StreamCompositionLayout() {
    }

    StreamCompositionLayout(Builder builder) {
        this.type = Objects.requireNonNull(builder.type, "Initial layout type is required.");
        this.screenshareType = builder.screenshareType;
        if (this.screenshareType != null && this.type != ScreenLayoutType.BEST_FIT) {
            throw new IllegalStateException("Layout type must be set to '" + (Object)((Object)ScreenLayoutType.BEST_FIT) + "' when setting the screen share layout.");
        }
        if (this.screenshareType == ScreenLayoutType.CUSTOM) {
            throw new IllegalArgumentException("Screen share type cannot be '" + (Object)((Object)ScreenLayoutType.CUSTOM) + "'.");
        }
        this.stylesheet = builder.stylesheet;
        if (this.stylesheet != null && this.type != ScreenLayoutType.CUSTOM) {
            throw new IllegalStateException("Layout type must be set to '" + (Object)((Object)ScreenLayoutType.CUSTOM) + "' when setting the stylesheet.");
        }
        if (this.type == ScreenLayoutType.CUSTOM && this.stylesheet == null) {
            throw new IllegalStateException("Stylesheet must be set when initial layout type is set to '" + (Object)((Object)ScreenLayoutType.CUSTOM) + "'.");
        }
    }

    @JsonProperty(value="type")
    public ScreenLayoutType getType() {
        return this.type;
    }

    @JsonProperty(value="screenshareType")
    public ScreenLayoutType getScreenshareType() {
        return this.screenshareType;
    }

    @JsonProperty(value="stylesheet")
    public String getStylesheet() {
        return this.stylesheet;
    }

    public static StreamCompositionLayout standardLayout(ScreenLayoutType initialLayout) {
        return new Builder(initialLayout).build();
    }

    public static StreamCompositionLayout customLayout(String stylesheet) {
        return new Builder(ScreenLayoutType.CUSTOM).stylesheet(stylesheet).build();
    }

    public static StreamCompositionLayout screenshareLayout(ScreenLayoutType screenshareType) {
        return new Builder(ScreenLayoutType.BEST_FIT).screenshareType(screenshareType).build();
    }

    static final class Builder {
        private final ScreenLayoutType type;
        private ScreenLayoutType screenshareType;
        private String stylesheet;

        Builder(ScreenLayoutType type) {
            this.type = type;
        }

        public Builder screenshareType(ScreenLayoutType screenshareType) {
            this.screenshareType = screenshareType;
            return this;
        }

        public Builder stylesheet(String stylesheet) {
            this.stylesheet = stylesheet;
            return this;
        }

        public StreamCompositionLayout build() {
            return new StreamCompositionLayout(this);
        }
    }
}

