/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.numbers.BaseNumbersFilter;
import com.vonage.client.numbers.Feature;
import com.vonage.client.numbers.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class SearchNumbersFilter
extends BaseNumbersFilter {
    private final Feature[] features;
    private final Type type;

    private SearchNumbersFilter(Builder builder) {
        super(builder);
        this.features = builder.features;
        this.type = builder.type;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.features != null && this.features.length > 0) {
            params.put("features", Arrays.stream(this.features).map(Enum::toString).collect(Collectors.joining(",")));
        }
        this.conditionalAdd("type", (Object)this.type);
        return params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseNumbersFilter.Builder<SearchNumbersFilter, Builder> {
        private Feature[] features;
        private Type type;

        private Builder() {
        }

        public Builder features(Feature ... features) {
            if (features != null) {
                this.features = (Feature[])Arrays.stream(features).distinct().toArray(Feature[]::new);
            }
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public SearchNumbersFilter build() {
            return new SearchNumbersFilter(this);
        }
    }
}

