/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.AbstractQueryParamsRequest;
import com.vonage.client.numbers.BaseNumberRequest;
import com.vonage.client.numbers.SearchPattern;
import java.util.Map;
import java.util.Objects;

abstract class BaseNumbersFilter
extends AbstractQueryParamsRequest {
    private final Integer index;
    private final Integer size;
    private final String pattern;
    private final String country;
    private final SearchPattern searchPattern;

    BaseNumbersFilter(Builder<?, ?> builder) {
        this.index = ((Builder)builder).index;
        if (this.index != null && this.index < 1) {
            throw new IllegalArgumentException("'index' must be positive.");
        }
        this.size = ((Builder)builder).size;
        if (this.size != null && (this.size < 1 || this.size > 100)) {
            throw new IllegalArgumentException("'size' must be between 1 and 100.");
        }
        this.country = ((Builder)builder).country != null ? BaseNumberRequest.validateCountry(((Builder)builder).country) : null;
        this.pattern = ((Builder)builder).pattern;
        this.searchPattern = ((Builder)builder).searchPattern;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPattern() {
        return this.pattern;
    }

    public SearchPattern getSearchPattern() {
        return this.searchPattern;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("index", this.index);
        this.conditionalAdd("size", this.size);
        this.conditionalAdd("pattern", this.pattern);
        if (this.searchPattern != null) {
            this.conditionalAdd("search_pattern", this.searchPattern.getValue());
        }
        this.conditionalAdd("country", this.country);
        return params;
    }

    public static abstract class Builder<F extends BaseNumbersFilter, B extends Builder<F, B>> {
        private Integer index;
        private Integer size;
        private String pattern;
        private String country;
        private SearchPattern searchPattern;

        Builder() {
        }

        public B country(String country) {
            this.country = country;
            return (B)this;
        }

        public B index(int index) {
            this.index = index;
            return (B)this;
        }

        public B size(int size) {
            this.size = size;
            return (B)this;
        }

        public B pattern(SearchPattern strategy, String pattern) {
            this.searchPattern = Objects.requireNonNull(strategy, "Matching strategy is required.");
            this.pattern = Objects.requireNonNull(pattern, "Pattern is required");
            return (B)this;
        }

        public abstract F build();
    }
}

