/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.CaptionMediaMessageRequest;
import com.vonage.client.messages.viber.ViberRequest;
import com.vonage.client.messages.viber.Video;
import java.util.Objects;

public final class ViberVideoRequest
extends ViberRequest
implements CaptionMediaMessageRequest {
    final Video video;

    ViberVideoRequest(Builder builder) {
        super(builder, MessageType.VIDEO);
        Objects.requireNonNull(builder.duration, "Duration is required.");
        Objects.requireNonNull(builder.fileSize, "File size is required.");
        this.video = new Video(this.media.getUrl().toString(), builder.thumbUrl, this.media.getCaption());
    }

    @JsonProperty(value="video")
    public Video getVideo() {
        return this.video;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ViberRequest.Builder<ViberVideoRequest, Builder>
    implements CaptionMediaMessageRequest.Builder<Builder> {
        String thumbUrl;

        Builder() {
        }

        @Override
        public Builder url(String url) {
            return (Builder)super.url(url);
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder fileSize(int fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        @Override
        public Builder caption(String caption) {
            return (Builder)super.caption(caption);
        }

        @Override
        public ViberVideoRequest build() {
            return new ViberVideoRequest(this);
        }
    }
}

